/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.benchmarks;

import com.github.chen0040.benchmarks.ResourceFileUtils;
import com.github.chen0040.benchmarks.Vector2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TspBenchmark {
    private static final Logger logger = LoggerFactory.getLogger(TspBenchmark.class);
    private final Map<Integer, Vector2D> points = new HashMap<Integer, Vector2D>();
    private final double[][] distances;
    private final int N;
    private final List<Integer> optTour = new ArrayList<Integer>();
    private final double bestCost;

    public TspBenchmark(String topologyFilename, String optTourFilename) {
        int i;
        InputStream inputStream = ResourceFileUtils.getResource(topologyFilename);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            reader.lines().forEach(line -> {
                String[] comps = line.split(",");
                int v = Integer.parseInt(comps[0]) - 1;
                double x = Double.parseDouble(comps[1]);
                double y = Double.parseDouble(comps[2]);
                Vector2D pos = new Vector2D(x, y);
                this.points.put(v, pos);
            });
        }
        catch (IOException exception) {
            logger.error("Failed to read the file " + topologyFilename, (Throwable)exception);
        }
        this.N = this.points.size();
        this.distances = new double[this.N][];
        for (i = 0; i < this.N; ++i) {
            this.distances[i] = new double[this.N];
        }
        for (i = 0; i < this.N; ++i) {
            for (int j = i + 1; j < this.N; ++j) {
                double distance;
                this.distances[i][j] = distance = this.points.get(i).distance(this.points.get(j));
                this.distances[j][i] = distance;
            }
        }
        inputStream = ResourceFileUtils.getResource(optTourFilename);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            reader.lines().forEach(line -> {
                int v = Integer.parseInt(line) - 1;
                this.optTour.add(v);
            });
        }
        catch (IOException exception) {
            logger.error("Failed to read the file " + topologyFilename, (Throwable)exception);
        }
        double cost = 0.0;
        for (int i2 = 0; i2 < this.optTour.size(); ++i2) {
            int j = (i2 + 1) % this.optTour.size();
            int v = this.optTour.get(i2);
            int w = this.optTour.get(j);
            double distance = this.distances[v][w];
            cost += distance;
        }
        this.bestCost = cost;
    }

    public int size() {
        return this.N;
    }

    public double optCost() {
        return this.bestCost;
    }

    public List<Integer> optTour() {
        return this.optTour;
    }

    public double distance(int v, int w) {
        return this.distances[v][w];
    }

    public Vector2D position(int v) {
        return this.points.get(v);
    }
}

