/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.utils;

import com.checkmarx.sdk.utils.ScanUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void zipFile(String fileToZip, String zipFile, String excludePatterns) throws IOException {
        List<String> excludeList = null;
        log.info("Creating zip file {} from contents of path {}", (Object)zipFile, (Object)fileToZip);
        if (excludePatterns != null) {
            log.info("Applying exclusions: {}", (Object)excludePatterns);
        }
        if (!ScanUtils.empty(excludePatterns)) {
            excludeList = Arrays.asList(excludePatterns.split(","));
        }
        zipFile = FileSystems.getDefault().getPath(zipFile, new String[0]).toAbsolutePath().toString();
        log.debug("Zip Absolute path: {}", (Object)zipFile);
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));){
            File srcFile = new File(fileToZip);
            if (srcFile.isDirectory()) {
                for (String fileName : Objects.requireNonNull(srcFile.list())) {
                    ZipUtils.addToZip("", String.format("%s/%s", fileToZip, fileName), zipFile, zipOut, excludeList);
                }
            } else {
                ZipUtils.addToZip("", fileToZip, zipFile, zipOut, excludeList);
            }
            zipOut.flush();
        }
        log.info("Successfully created {} ", (Object)zipFile);
    }

    private static void addToZip(String path, String srcFile, String zipFile, ZipOutputStream zipOut, List<String> excludePatterns) throws IOException {
        String filePath;
        File file = new File(srcFile);
        String string = filePath = "".equals(path) ? file.getName() : String.format("%s/%s", path, file.getName());
        if (file.isDirectory()) {
            for (String fileName : Objects.requireNonNull(file.list())) {
                ZipUtils.addToZip(filePath, srcFile + "/" + fileName, zipFile, zipOut, excludePatterns);
            }
        } else {
            String tmpPath = FileSystems.getDefault().getPath(srcFile, new String[0]).toAbsolutePath().toString();
            tmpPath = tmpPath.replace("/./", "/");
            tmpPath = tmpPath.replace("\\.\\", "\\");
            log.debug("@@@ {} | {} @@@", (Object)zipFile, (Object)tmpPath);
            if (tmpPath.equals(zipFile)) {
                log.debug("#########Skipping the new zip file {}#########", (Object)zipFile);
                return;
            }
            if (excludePatterns == null || excludePatterns.isEmpty() || !ZipUtils.anyMatches(excludePatterns, filePath)) {
                zipOut.putNextEntry(new ZipEntry(filePath));
                try (FileInputStream in = new FileInputStream(srcFile);){
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = in.read(buffer)) != -1) {
                        zipOut.write(buffer, 0, len);
                    }
                }
            }
        }
    }

    private static boolean anyMatches(List<String> patterns, String str) {
        for (String pattern : patterns) {
            if (!ZipUtils.strMatches(pattern = pattern.trim(), str)) continue;
            log.debug("match: {}|{}", (Object)pattern, (Object)str);
            return true;
        }
        return false;
    }

    private static boolean strMatches(String patternStr, String str) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            return start == 0 && end == str.length();
        }
        return false;
    }
}

