/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.service;

import com.checkmarx.sdk.config.ScaProperties;
import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.sca.SCAParams;
import com.checkmarx.sdk.dto.sca.SCAResults;
import com.checkmarx.sdk.exception.SCARuntimeException;
import com.checkmarx.sdk.service.ScaClient;
import com.cx.restclient.CxShragaClient;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.DependencyScanResults;
import com.cx.restclient.dto.DependencyScannerType;
import com.cx.restclient.sca.dto.RemoteRepositoryInfo;
import com.cx.restclient.sca.dto.SCAConfig;
import com.cx.restclient.sca.dto.SourceLocationType;
import com.cx.restclient.sca.dto.report.SCASummaryResults;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScaClientImpl
implements ScaClient {
    private static final Logger log = LoggerFactory.getLogger(ScaClientImpl.class);
    private static final String ERROR_PREFIX = "SCA scan cannot be initiated.";
    private final ScaProperties scaProperties;

    @Override
    public SCAResults scanRemoteRepo(SCAParams scaParams) throws IOException {
        this.validate(scaParams);
        CxScanConfig scanConfig = this.getScanConfig(scaParams);
        DependencyScanResults scanResults = this.executeScan(scanConfig);
        return this.toScaResults(scanResults.getScaResults());
    }

    private SCAResults toScaResults(com.cx.restclient.sca.dto.SCAResults scaResultsFromCommonClient) {
        this.validateNotNull(scaResultsFromCommonClient);
        SCASummaryResults summary = scaResultsFromCommonClient.getSummary();
        Map<Filter.Severity, Integer> findingCountsPerSeverity = this.getFindingCountMap(summary);
        ModelMapper mapper = new ModelMapper();
        SCAResults result = (SCAResults)mapper.map((Object)scaResultsFromCommonClient, SCAResults.class);
        result.getSummary().setFindingCounts(findingCountsPerSeverity);
        return result;
    }

    private Map<Filter.Severity, Integer> getFindingCountMap(SCASummaryResults summary) {
        EnumMap<Filter.Severity, Integer> result = new EnumMap<Filter.Severity, Integer>(Filter.Severity.class);
        result.put(Filter.Severity.HIGH, summary.getHighVulnerabilityCount());
        result.put(Filter.Severity.MEDIUM, summary.getMediumVulnerabilityCount());
        result.put(Filter.Severity.LOW, summary.getLowVulnerabilityCount());
        return result;
    }

    private CxScanConfig getScanConfig(SCAParams scaParams) {
        CxScanConfig cxScanConfig = new CxScanConfig();
        cxScanConfig.setDependencyScannerType(DependencyScannerType.SCA);
        cxScanConfig.setSastEnabled(Boolean.valueOf(false));
        cxScanConfig.setProjectName(scaParams.getProjectName());
        cxScanConfig.setScaConfig(this.getSCAConfig(scaParams));
        return cxScanConfig;
    }

    private SCAConfig getSCAConfig(SCAParams scaParams) {
        SCAConfig scaConfig = new SCAConfig();
        scaConfig.setWebAppUrl(this.scaProperties.getAppUrl());
        scaConfig.setApiUrl(this.scaProperties.getApiUrl());
        scaConfig.setAccessControlUrl(this.scaProperties.getAccessControlUrl());
        scaConfig.setTenant(this.scaProperties.getTenant());
        scaConfig.setUsername(this.scaProperties.getUsername());
        scaConfig.setPassword(this.scaProperties.getPassword());
        scaConfig.setSourceLocationType(SourceLocationType.REMOTE_REPOSITORY);
        RemoteRepositoryInfo remoteRepoInfo = new RemoteRepositoryInfo();
        remoteRepoInfo.setUrl(scaParams.getRemoteRepoUrl());
        scaConfig.setRemoteRepositoryInfo(remoteRepoInfo);
        return scaConfig;
    }

    private DependencyScanResults executeScan(CxScanConfig cxScanConfig) throws IOException {
        CxShragaClient client = new CxShragaClient(cxScanConfig, log);
        client.init();
        client.createDependencyScan();
        return client.waitForDependencyScanResults();
    }

    private void validate(SCAParams scaParams) {
        this.validateNotNull(scaParams);
        this.validateNotEmpty(this.scaProperties.getAppUrl(), "SCA application URL");
        this.validateNotEmpty(this.scaProperties.getApiUrl(), "SCA API URL");
        this.validateNotEmpty(this.scaProperties.getAccessControlUrl(), "SCA Access Control URL");
        this.validateNotEmpty(scaParams.getProjectName(), "Project name");
        this.validateNotEmpty(this.scaProperties.getTenant(), "SCA tenant");
        this.validateNotEmpty(this.scaProperties.getUsername(), "Username");
        this.validateNotEmpty(this.scaProperties.getPassword(), "Password");
    }

    private void validateNotNull(SCAParams scaParams) {
        if (scaParams == null) {
            throw new SCARuntimeException(String.format("%s SCA parameters weren't provided.", ERROR_PREFIX));
        }
        if (scaParams.getRemoteRepoUrl() == null) {
            throw new SCARuntimeException(String.format("%s Repository URL wasn't provided.", ERROR_PREFIX));
        }
    }

    private void validateNotNull(com.cx.restclient.sca.dto.SCAResults scaResults) {
        if (scaResults == null) {
            throw new SCARuntimeException("SCA results are missing.");
        }
        SCASummaryResults summary = scaResults.getSummary();
        if (summary == null) {
            throw new SCARuntimeException("SCA results don't contain a summary.");
        }
    }

    private void validateNotEmpty(String parameter, String parameterDescr) {
        if (StringUtils.isEmpty((CharSequence)parameter)) {
            String message = String.format("%s %s wasn't provided", ERROR_PREFIX, parameterDescr);
            throw new SCARuntimeException(message);
        }
    }

    public ScaClientImpl(ScaProperties scaProperties) {
        this.scaProperties = scaProperties;
    }
}

