/*
 * Decompiled with CFR 0.152.
 */
package scalacache.redis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.util.Pool;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scalacache.Cache;
import scalacache.LoggingSupport;
import scalacache.redis.RedisSerialization;
import scalacache.redis.StringEnrichment$;
import scalacache.redis.StringEnrichment$StringWithUtf8Bytes$;
import scalacache.serialization.Codec;

@ScalaSignature(bytes="\u0006\u0001\u0005ucaB\u0001\u0003!\u0003\r\ta\u0002\u0002\u000f%\u0016$\u0017n]\"bG\",')Y:f\u0015\t\u0019A!A\u0003sK\u0012L7OC\u0001\u0006\u0003)\u00198-\u00197bG\u0006\u001c\u0007.Z\u0002\u0001'\u0015\u0001\u0001B\u0004\r\u001d!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0019q\u0002\u0005\n\u000e\u0003\u0011I!!\u0005\u0003\u0003\u000b\r\u000b7\r[3\u0011\u0007%\u0019R#\u0003\u0002\u0015\u0015\t)\u0011I\u001d:bsB\u0011\u0011BF\u0005\u0003/)\u0011AAQ=uKB\u0011\u0011DG\u0007\u0002\u0005%\u00111D\u0001\u0002\u0013%\u0016$\u0017n]*fe&\fG.\u001b>bi&|g\u000e\u0005\u0002\u0010;%\u0011a\u0004\u0002\u0002\u000f\u0019><w-\u001b8h'V\u0004\bo\u001c:u\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019!\u0013N\\5uIQ\t!\u0005\u0005\u0002\nG%\u0011AE\u0003\u0002\u0005+:LG\u000fC\u0004'\u0001\t\u0007IQK\u0014\u0002\r1|wmZ3s+\u0005A\u0003CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005i\u0013aA8sO&\u0011qF\u000b\u0002\u0007\u0019><w-\u001a:\t\u000bE\u0002a1\u0001\u001a\u0002\u0017\u0015DXmY\"p]R,\u0007\u0010^\u000b\u0002gA\u0011AgN\u0007\u0002k)\u0011aGC\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u001d6\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fB\u0003;\u0001\tE1HA\u0004K\u00072LWM\u001c;\u0012\u0005qz\u0004CA\u0005>\u0013\tq$BA\u0004O_RD\u0017N\\4\u0013\u0007\u0001\u00135J\u0002\u0003B\u0001\u0001y$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CA\"J\u001b\u0005!%BA#G\u0003\u0015QW\rZ5t\u0015\t9\u0005*A\u0004dY&,g\u000e^:\u000b\u0003\rI!A\u0013#\u0003'\tKg.\u0019:z\u0015\u0016$\u0017n]\"p[6\fg\u000eZ:\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015AA5p\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\u0013\rcwn]3bE2,\u0007\"\u0002+\u0001\r#)\u0016!\u00036fI&\u001c\bk\\8m+\u00051\u0006cA,[96\t\u0001L\u0003\u0002Z\r\u0006!Q\u000f^5m\u0013\tY\u0006L\u0001\u0003Q_>d\u0007CA/:\u001b\u0005\u0001\u0001\"B0\u0001\t+\u0001\u0017!E<ji\"TU\rZ5t\u0007>lW.\u00198egV\u0011\u0011\r\u001a\u000b\u0003E*\u0004\"a\u00193\r\u0001\u0011)QM\u0018b\u0001M\n\tA+\u0005\u0002=OB\u0011\u0011\u0002[\u0005\u0003S*\u00111!\u00118z\u0011\u0015Yg\f1\u0001m\u0003\u00051\u0007\u0003B\u0005n\u0005\nL!A\u001c\u0006\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"\u00029\u0001\t\u000b\n\u0018aA4fiV\u0011!o\u001f\u000b\u0004g\u0006-AC\u0001;~!\r!To^\u0005\u0003mV\u0012aAR;ukJ,\u0007cA\u0005yu&\u0011\u0011P\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\r\\H!\u0002?p\u0005\u00041'!\u0001,\t\u000by|\u00079A@\u0002\u000b\r|G-Z2\u0011\r\u0005\u0005\u0011q\u0001>\u0013\u001b\t\t\u0019AC\u0002\u0002\u0006\u0011\tQb]3sS\u0006d\u0017N_1uS>t\u0017\u0002BA\u0005\u0003\u0007\u0011QaQ8eK\u000eDq!!\u0004p\u0001\u0004\ty!A\u0002lKf\u0004B!!\u0005\u0002 9!\u00111CA\u000e!\r\t)BC\u0007\u0003\u0003/Q1!!\u0007\u0007\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0004\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\tiB\u0003\u0005\b\u0003O\u0001AQIA\u0015\u0003\r\u0001X\u000f^\u000b\u0005\u0003W\t9\u0004\u0006\u0005\u0002.\u0005e\u00121HA )\u0011\ty#!\r\u0011\u0007Q*(\u0005C\u0004\u007f\u0003K\u0001\u001d!a\r\u0011\u000f\u0005\u0005\u0011qAA\u001b%A\u00191-a\u000e\u0005\rq\f)C1\u0001g\u0011!\ti!!\nA\u0002\u0005=\u0001\u0002CA\u001f\u0003K\u0001\r!!\u000e\u0002\u000bY\fG.^3\t\u0011\u0005\u0005\u0013Q\u0005a\u0001\u0003\u0007\n1\u0001\u001e;m!\u0011I\u00010!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u00136\u0003!!WO]1uS>t\u0017\u0002BA(\u0003\u0013\u0012\u0001\u0002R;sCRLwN\u001c\u0005\b\u0003'\u0002AQIA+\u0003\u0019\u0011X-\\8wKR!\u0011qFA,\u0011!\ti!!\u0015A\u0002\u0005=\u0001BBA.\u0001\u0011\u0015\u0013%A\u0003dY>\u001cX\r")
public interface RedisCacheBase
extends Cache<byte[]>,
RedisSerialization,
LoggingSupport {
    public void scalacache$redis$RedisCacheBase$_setter_$logger_$eq(Logger var1);

    public Logger logger();

    public ExecutionContext execContext();

    public Pool<BinaryJedisCommands> jedisPool();

    public static /* synthetic */ Object withJedisCommands$(RedisCacheBase $this, Function1 f) {
        return $this.withJedisCommands(f);
    }

    default public <T> T withJedisCommands(Function1<BinaryJedisCommands, T> f) {
        Object object;
        try (BinaryJedisCommands jedis = (BinaryJedisCommands)this.jedisPool().getResource();){
            object = f.apply((Object)jedis);
        }
        return (T)object;
    }

    public static /* synthetic */ Future get$(RedisCacheBase $this, String key, Codec codec) {
        return $this.get(key, codec);
    }

    default public <V> Future<Option<V>> get(String key, Codec<V, byte[]> codec) {
        return Future$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> (Option)package$.MODULE$.blocking((Function0 & java.io.Serializable & Serializable)() -> (Option)this.withJedisCommands((Function1 & java.io.Serializable & Serializable)jedis -> {
            None$ result;
            block0: {
                byte[] bytes = jedis.get(StringEnrichment$StringWithUtf8Bytes$.MODULE$.utf8bytes$extension(StringEnrichment$.MODULE$.StringWithUtf8Bytes(key)));
                Object object = result = bytes != null ? new Some(this.deserialize(bytes, codec)) : None$.MODULE$;
                if (!this.logger().isDebugEnabled()) break block0;
                this.logCacheHitOrMiss(key, (Option)result);
            }
            return result;
        })), this.execContext());
    }

    public static /* synthetic */ Future put$(RedisCacheBase $this, String key, Object value, Option ttl, Codec codec) {
        return $this.put(key, value, (Option<Duration>)ttl, codec);
    }

    default public <V> Future<BoxedUnit> put(String key, V value, Option<Duration> ttl, Codec<V, byte[]> codec) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> package$.MODULE$.blocking((Function0 & java.io.Serializable & Serializable)() -> (String)this.withJedisCommands((Function1 & java.io.Serializable & Serializable)jedis -> {
            Duration d;
            byte[] keyBytes = StringEnrichment$StringWithUtf8Bytes$.MODULE$.utf8bytes$extension(StringEnrichment$.MODULE$.StringWithUtf8Bytes(key));
            byte[] valueBytes = this.serialize(value, codec);
            boolean bl = false;
            Some some = null;
            Option option = ttl;
            if (None$.MODULE$.equals(option)) {
                return jedis.set(keyBytes, valueBytes);
            }
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Duration duration = (Duration)some.value();
                FiniteDuration finiteDuration = Duration$.MODULE$.Zero();
                Duration duration2 = duration;
                if (finiteDuration == null) {
                    if (duration2 == null) return jedis.set(keyBytes, valueBytes);
                } else if (finiteDuration.equals(duration2)) {
                    return jedis.set(keyBytes, valueBytes);
                }
            }
            if (bl && (d = (Duration)some.value()).$less((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second())) {
                if (!this.logger().isWarnEnabled()) return jedis.setex(keyBytes, 1, valueBytes);
                this.logger().warn("Because Redis (pre 2.6.12) does not support sub-second expiry, TTL of $d will be rounded up to 1 second");
                return jedis.setex(keyBytes, 1, valueBytes);
            }
            if (!bl) throw new MatchError((Object)option);
            Duration d2 = (Duration)some.value();
            return jedis.setex(keyBytes, (int)d2.toSeconds(), valueBytes);
        })), this.execContext());
    }

    public static /* synthetic */ Future remove$(RedisCacheBase $this, String key) {
        return $this.remove(key);
    }

    default public Future<BoxedUnit> remove(String key) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> package$.MODULE$.blocking((Function0 & java.io.Serializable & Serializable)() -> (Long)this.withJedisCommands((Function1 & java.io.Serializable & Serializable)jedis -> jedis.del(StringEnrichment$StringWithUtf8Bytes$.MODULE$.utf8bytes$extension(StringEnrichment$.MODULE$.StringWithUtf8Bytes(key))))), this.execContext());
    }

    public static /* synthetic */ void close$(RedisCacheBase $this) {
        $this.close();
    }

    default public void close() {
        this.jedisPool().close();
    }

    public static void $init$(RedisCacheBase $this) {
        $this.scalacache$redis$RedisCacheBase$_setter_$logger_$eq(LoggerFactory.getLogger((String)$this.getClass().getName()));
    }
}

