/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.websocket.nv;

import com.github.catalystcode.fortis.speechtotext.lifecycle.MessageReceiver;
import com.github.catalystcode.fortis.speechtotext.telemetry.ConnectionTelemetry;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFrame;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

class NvMessageReceiver
extends WebSocketAdapter {
    private static final Logger log = Logger.getLogger(NvMessageReceiver.class);
    private final CountDownLatch socketCloseLatch;
    private final MessageReceiver receiver;
    private final ConnectionTelemetry telemetry;

    NvMessageReceiver(CountDownLatch countDownLatch, MessageReceiver messageReceiver, ConnectionTelemetry connectionTelemetry) {
        this.socketCloseLatch = countDownLatch;
        this.receiver = messageReceiver;
        this.telemetry = connectionTelemetry;
    }

    public void onConnected(WebSocket webSocket, Map<String, List<String>> map) throws Exception {
        this.telemetry.recordConnectionEstablished();
        log.debug((Object)"Websocket connected");
    }

    public void onConnectError(WebSocket webSocket, WebSocketException webSocketException) throws Exception {
        this.telemetry.recordConnectionFailed(webSocketException.getMessage());
        log.error((Object)"Websocket connection failed", (Throwable)webSocketException);
    }

    public void onTextMessage(WebSocket webSocket, String string) throws Exception {
        this.receiver.onMessage(string);
    }

    public void onError(WebSocket webSocket, WebSocketException webSocketException) throws Exception {
        log.error((Object)"Websocket read error", (Throwable)webSocketException);
        this.socketCloseLatch.countDown();
    }

    public void onCloseFrame(WebSocket webSocket, WebSocketFrame webSocketFrame) throws Exception {
        int n = webSocketFrame.getCloseCode();
        String string = webSocketFrame.getCloseReason();
        log.info((Object)("Websocket closed with status '" + n + "' and reason '" + string + "'"));
        this.socketCloseLatch.countDown();
    }
}

