/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.websocket;

import com.github.catalystcode.fortis.speechtotext.telemetry.AudioTelemetry;
import com.github.catalystcode.fortis.speechtotext.telemetry.CallsTelemetry;
import com.github.catalystcode.fortis.speechtotext.telemetry.ConnectionTelemetry;
import com.github.catalystcode.fortis.speechtotext.utils.MessageUtils;
import com.github.catalystcode.fortis.speechtotext.utils.ProtocolUtils;
import com.github.catalystcode.fortis.speechtotext.websocket.PlatformInfo;
import com.github.catalystcode.fortis.speechtotext.websocket.TelemetryInfo;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public abstract class MessageSender {
    private static final Logger log = Logger.getLogger(MessageSender.class);
    private final String connectionId;
    private final String requestId;

    protected MessageSender(String string) {
        this.connectionId = string;
        this.requestId = ProtocolUtils.newGuid();
    }

    public final void sendConfiguration() {
        String string = new PlatformInfo().toJson();
        String string2 = MessageUtils.createTextMessage("speech.config", this.requestId, "application/json; charset=utf-8", string);
        this.sendTextMessage(string2);
        log.info((Object)("Sent speech config: " + string));
    }

    public final void sendAudio(InputStream inputStream) {
        AudioTelemetry audioTelemetry = AudioTelemetry.forId(this.requestId);
        audioTelemetry.recordAudioStarted();
        try {
            ByteBuffer byteBuffer;
            int n;
            byte[] byArray = new byte[8192];
            int n2 = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                byteBuffer = MessageUtils.createBinaryMessage("audio", this.requestId, "audio/wav", byArray, n);
                this.sendBinaryMessage(byteBuffer);
                log.debug((Object)("Sent audio chunk " + ++n2 + "with " + n + " bytes"));
            }
            byteBuffer = MessageUtils.createBinaryMessage("audio", this.requestId, "audio/wav", new byte[0], 0);
            this.sendBinaryMessage(byteBuffer);
            log.info((Object)("Sent " + n2 + " audio chunks"));
        }
        catch (Exception exception) {
            audioTelemetry.recordAudioFailed(exception.getMessage());
            throw new RuntimeException(exception);
        }
        finally {
            audioTelemetry.recordAudioEnded();
        }
    }

    public final void sendTelemetry() {
        CallsTelemetry callsTelemetry = CallsTelemetry.forId(this.requestId);
        ConnectionTelemetry connectionTelemetry = ConnectionTelemetry.forId(this.connectionId);
        AudioTelemetry audioTelemetry = AudioTelemetry.forId(this.requestId);
        String string = new TelemetryInfo(this.connectionId, callsTelemetry, connectionTelemetry, audioTelemetry).toJson();
        String string2 = MessageUtils.createTextMessage("telemetry", this.requestId, "application/json; charset=utf-8", string);
        this.sendTextMessage(string2);
        log.info((Object)("Sent telemetry: " + string));
    }

    protected abstract void sendBinaryMessage(ByteBuffer var1);

    protected abstract void sendTextMessage(String var1);
}

