/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.utils;

import com.github.catalystcode.fortis.speechtotext.utils.ProtocolUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static Map<String, String> parseHeaders(String string) {
        String[] stringArray = string.split("\r\n\r\n");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Message '" + string + "' does not have header and body");
        }
        String[] stringArray2 = stringArray[0].split("\r\n");
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray2.length);
        for (String string2 : stringArray2) {
            String[] stringArray3 = string2.split(":");
            if (stringArray3.length < 2) {
                throw new IllegalArgumentException("Header '" + string2 + "' does not have a name and value");
            }
            String string3 = stringArray3[0].trim();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 1; i < stringArray3.length; ++i) {
                stringBuilder.append(stringArray3[i]).append(':');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            String string4 = stringBuilder.toString().trim();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public static JSONObject parseBody(String string) {
        String[] stringArray = string.split("\r\n\r\n");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Message '" + string + "' does not have header and body");
        }
        String string2 = stringArray[1];
        return new JSONObject(string2);
    }

    public static ByteBuffer createBinaryMessage(String string, String string2, String string3, byte[] byArray, int n) {
        byte[] byArray2 = MessageUtils.addHeaders(new StringBuilder(), string, string2, string3).toString().getBytes(StandardCharsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + byArray2.length + n);
        byteBuffer.putShort(MessageUtils.toShort(byArray2.length));
        byteBuffer.put(byArray2);
        if (n > 0) {
            byteBuffer.put(byArray, 0, n);
        }
        return byteBuffer;
    }

    public static String createTextMessage(String string, String string2, String string3, String string4) {
        return MessageUtils.addHeaders(new StringBuilder(), string, string2, string3).append("\r\n").append(string4).toString();
    }

    private static StringBuilder addHeaders(StringBuilder stringBuilder, String string, String string2, String string3) {
        stringBuilder.append("Path").append(": ").append(string).append("\r\n");
        stringBuilder.append("X-RequestId").append(": ").append(string2).append("\r\n");
        stringBuilder.append("X-Timestamp").append(": ").append(ProtocolUtils.newTimestamp()).append("\r\n");
        stringBuilder.append("Content-Type").append(": ").append(string3).append("\r\n");
        return stringBuilder;
    }

    private static short toShort(int n) {
        if (n > Short.MAX_VALUE) {
            throw new IllegalArgumentException(n + " > " + Short.MAX_VALUE);
        }
        if (n < Short.MIN_VALUE) {
            throw new IllegalArgumentException(n + " < " + Short.MIN_VALUE);
        }
        return (short)n;
    }
}

