/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.telemetry;

import com.github.catalystcode.fortis.speechtotext.utils.ProtocolUtils;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public final class CallsTelemetry {
    private static final ConcurrentMap<String, CallsTelemetry> POOL = new ConcurrentHashMap<String, CallsTelemetry>();
    private final ConcurrentMap<String, Queue<String>> callTimestamps = new ConcurrentHashMap<String, Queue<String>>();

    private CallsTelemetry() {
    }

    public void recordCall(String string) {
        ConcurrentLinkedQueue<String> concurrentLinkedQueue;
        String string2 = ProtocolUtils.newTimestamp();
        ConcurrentLinkedQueue<String> concurrentLinkedQueue2 = (ConcurrentLinkedQueue<String>)this.callTimestamps.get(string);
        if (concurrentLinkedQueue2 == null && (concurrentLinkedQueue2 = (Queue)this.callTimestamps.putIfAbsent(string, concurrentLinkedQueue = new ConcurrentLinkedQueue<String>())) == null) {
            concurrentLinkedQueue2 = concurrentLinkedQueue;
        }
        concurrentLinkedQueue2.add(string2);
    }

    public Map<String, Queue<String>> getCallTimestamps() {
        return this.callTimestamps;
    }

    public static CallsTelemetry forId(String string) {
        CallsTelemetry callsTelemetry;
        CallsTelemetry callsTelemetry2 = (CallsTelemetry)POOL.get(string);
        if (callsTelemetry2 == null && (callsTelemetry2 = POOL.putIfAbsent(string, callsTelemetry = new CallsTelemetry())) == null) {
            callsTelemetry2 = callsTelemetry;
        }
        return callsTelemetry2;
    }
}

