/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.telemetry;

import com.github.catalystcode.fortis.speechtotext.utils.ProtocolUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class AudioTelemetry {
    private static final ConcurrentMap<String, AudioTelemetry> POOL = new ConcurrentHashMap<String, AudioTelemetry>();
    private String audioStarted;
    private String audioEnded;
    private String audioErrored;

    private AudioTelemetry() {
    }

    public void recordAudioStarted() {
        if (this.audioStarted == null) {
            this.audioStarted = ProtocolUtils.newTimestamp();
        }
    }

    public void recordAudioEnded() {
        if (this.audioEnded == null) {
            this.audioEnded = ProtocolUtils.newTimestamp();
        }
    }

    public void recordAudioFailed(String string) {
        this.audioEnded = ProtocolUtils.newTimestamp();
        this.audioErrored = string;
    }

    public String getAudioErrored() {
        return this.audioErrored;
    }

    public String getAudioEnded() {
        return this.audioEnded;
    }

    public String getAudioStarted() {
        return this.audioStarted;
    }

    public static AudioTelemetry forId(String string) {
        AudioTelemetry audioTelemetry;
        AudioTelemetry audioTelemetry2 = (AudioTelemetry)POOL.get(string);
        if (audioTelemetry2 == null && (audioTelemetry2 = POOL.putIfAbsent(string, audioTelemetry = new AudioTelemetry())) == null) {
            audioTelemetry2 = audioTelemetry;
        }
        return audioTelemetry2;
    }
}

