/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.lifecycle;

import com.github.catalystcode.fortis.speechtotext.utils.Func;
import org.apache.log4j.Logger;
import org.json.JSONObject;

final class SpeechPhraseMessage {
    private static final Logger log = Logger.getLogger(SpeechPhraseMessage.class);

    private SpeechPhraseMessage() {
    }

    static void handle(JSONObject jSONObject, Func<String> func) {
        if (!SpeechPhraseMessage.isSuccess(jSONObject)) {
            return;
        }
        String string = jSONObject.getString("DisplayText");
        func.call(string);
    }

    private static boolean isSuccess(JSONObject jSONObject) {
        String string = jSONObject.getString("RecognitionStatus");
        if ("EndOfDictation".equalsIgnoreCase(string)) {
            log.info((Object)"Detected end of speech");
            return false;
        }
        if (!"Success".equalsIgnoreCase(string)) {
            log.warn((Object)("Unable to recognize audio: " + jSONObject));
            return false;
        }
        return true;
    }
}

