/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext.lifecycle;

import com.github.catalystcode.fortis.speechtotext.lifecycle.SpeechPhraseMessage;
import com.github.catalystcode.fortis.speechtotext.lifecycle.TurnEndMessage;
import com.github.catalystcode.fortis.speechtotext.telemetry.CallsTelemetry;
import com.github.catalystcode.fortis.speechtotext.utils.Func;
import com.github.catalystcode.fortis.speechtotext.utils.MessageUtils;
import com.github.catalystcode.fortis.speechtotext.websocket.MessageSender;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class MessageReceiver {
    private static final Logger log = Logger.getLogger(MessageReceiver.class);
    private final Func<String> onResult;
    private final CountDownLatch endLatch;
    private MessageSender sender;

    public MessageReceiver(Func<String> func, CountDownLatch countDownLatch) {
        this.onResult = func;
        this.endLatch = countDownLatch;
    }

    public void onMessage(String string) {
        Map<String, String> map = MessageUtils.parseHeaders(string);
        JSONObject jSONObject = MessageUtils.parseBody(string);
        String string2 = map.get("Path");
        String string3 = map.get("X-RequestId");
        CallsTelemetry.forId(string3).recordCall(string2);
        log.debug((Object)("Got message at path " + string2 + " with payload '" + jSONObject + "'"));
        if ("speech.phrase".equalsIgnoreCase(string2)) {
            SpeechPhraseMessage.handle(jSONObject, this.onResult);
        } else if ("turn.end".equalsIgnoreCase(string2)) {
            TurnEndMessage.handle(this.sender, this.endLatch);
        }
    }

    public void setSender(MessageSender messageSender) {
        this.sender = messageSender;
    }
}

