/*
 * Decompiled with CFR 0.152.
 */
package com.github.catalystcode.fortis.speechtotext;

import com.github.catalystcode.fortis.speechtotext.config.SpeechServiceConfig;
import com.github.catalystcode.fortis.speechtotext.lifecycle.MessageReceiver;
import com.github.catalystcode.fortis.speechtotext.utils.Func;
import com.github.catalystcode.fortis.speechtotext.websocket.MessageSender;
import com.github.catalystcode.fortis.speechtotext.websocket.SpeechServiceClient;
import com.github.catalystcode.fortis.speechtotext.websocket.nv.NvSpeechServiceClient;
import java.io.InputStream;

public class SpeechTranscriber {
    private final SpeechServiceConfig config;
    private final SpeechServiceClient client;

    public SpeechTranscriber(SpeechServiceConfig speechServiceConfig) {
        this(speechServiceConfig, new NvSpeechServiceClient());
    }

    public SpeechTranscriber(SpeechServiceConfig speechServiceConfig, SpeechServiceClient speechServiceClient) {
        this.config = speechServiceConfig;
        this.client = speechServiceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcribe(InputStream inputStream, Func<String> func) throws Exception {
        MessageReceiver messageReceiver = new MessageReceiver(func, this.client.getEndLatch());
        try {
            MessageSender messageSender = this.client.start(this.config, messageReceiver);
            messageReceiver.setSender(messageSender);
            messageSender.sendConfiguration();
            this.sendAudioAsync(inputStream, messageSender);
            this.client.awaitEnd();
        }
        finally {
            this.client.stop();
        }
    }

    private void sendAudioAsync(InputStream inputStream, MessageSender messageSender) {
        new Thread(() -> messageSender.sendAudio(inputStream)).run();
    }
}

