/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.worker.policy.testing.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.corepolicy.ProcessingAction;
import com.github.cafdataprocessing.corepolicy.common.Document;
import com.github.cafdataprocessing.corepolicy.common.dto.ConflictResolutionMode;
import com.github.cafdataprocessing.corepolicy.common.dto.Policy;
import com.github.cafdataprocessing.corepolicy.common.dto.PolicyType;
import com.github.cafdataprocessing.corepolicy.policy.TagPolicy.TagPolicy;
import com.github.cafdataprocessing.worker.policy.TagPolicyHandlerBase;
import java.io.IOException;
import java.util.Collection;

public class IndexWorkerHandler
extends TagPolicyHandlerBase {
    private static final String policyTypeJson = "{\n    \"properties\": {\n        \"fieldActions\": {\n            \"type\": \"array\",\n            \"items\": {\n                \"title\": \"Field Action\",\n                \"type\": \"object\",\n                \"properties\": {\n                    \"name\": {\n                        \"description\": \"The name of the field to perform the action on.\",\n                        \"type\": \"string\",\n                        \"minLength\": 1\n                    },\n                    \"action\": {\n                        \"description\": \"The type of action to perform on the field.\",\n                        \"type\": \"string\",\n                        \"enum\": [\n                            \"ADD_FIELD_VALUE\"\n                        ]\n                    },\n                    \"value\": {\n                        \"description\": \"The value to use for the field action.\",\n                        \"type\": \"string\"\n                    }\n                },\n                \"required\": [\"name\", \"action\"]\n            }\n        }\n    } \n}";

    public PolicyType getPolicyType() {
        PolicyType policyType = new PolicyType();
        policyType.conflictResolutionMode = ConflictResolutionMode.PRIORITY;
        ObjectMapper m = new ObjectMapper();
        JsonNode definition = null;
        try {
            definition = m.readTree(policyTypeJson);
        }
        catch (IOException e) {
            logger.error("Could not deseralise policy type definition", (Throwable)e);
        }
        policyType.definition = definition;
        policyType.name = "Test IndexPolicy Type";
        policyType.description = "Used to create testing index policies";
        policyType.shortName = "TestHandlers-IndexPolicy";
        return policyType;
    }

    protected ProcessingAction handlePolicy(Document document, Policy policy, Long collectionSequenceId) {
        TagPolicy policy1 = this.getTagPolicy(policy);
        this.applyFieldActions(document, policy1.getFieldActions());
        return ProcessingAction.CONTINUE_PROCESSING;
    }

    public Collection<Policy> resolve(Document document, Collection<Policy> policies) {
        return null;
    }
}

