/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.worker.policy.testing.handlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.github.cafdataprocessing.corepolicy.common.Document;
import com.github.cafdataprocessing.corepolicy.common.dto.Policy;
import com.github.cafdataprocessing.corepolicy.common.dto.PolicyType;
import com.github.cafdataprocessing.entity.fields.DocumentProcessingRecord;
import com.github.cafdataprocessing.worker.policy.WorkerTaskResponsePolicyHandler;
import com.github.cafdataprocessing.worker.policy.converters.DocumentConverter;
import com.github.cafdataprocessing.worker.policy.data.reprocessing.builder.PolicyReprocessingDocumentBuilder;
import com.github.cafdataprocessing.worker.policy.data.reprocessing.builder.exceptions.PolicyReprocessingReconstructMessageException;
import com.github.cafdataprocessing.worker.policy.handlers.shared.document.SharedDocument;
import com.github.cafdataprocessing.worker.policy.shared.DocumentInterface;
import com.github.cafdataprocessing.worker.policy.shared.TaskData;
import com.github.cafdataprocessing.worker.policy.testing.handlers.DataReproPolicyDefinition;
import com.github.cafdataprocessing.worker.policy.testing.handlers.DataReproTask;
import com.hpe.caf.api.worker.InvalidTaskException;
import com.hpe.caf.api.worker.TaskStatus;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;

public class DataReprocessingTestHandler
extends WorkerTaskResponsePolicyHandler {
    protected WorkerTaskResponsePolicyHandler.WorkerHandlerResponse handleTaskPolicy(Document document, Policy policy, Long aLong, TaskData taskData) throws InvalidTaskException {
        DataReproTask task = new DataReproTask();
        com.github.cafdataprocessing.worker.policy.shared.Document currentPolicyWorkerDoc = taskData.getDocument();
        com.github.cafdataprocessing.worker.policy.shared.Document finalPolicyWorkerOutput = new DocumentConverter().convert(document);
        if (currentPolicyWorkerDoc != null) {
            DocumentProcessingRecord taskDataProcessingRecord;
            if (currentPolicyWorkerDoc.getMetadataReferences() != null) {
                finalPolicyWorkerOutput.setMetadataReferences(currentPolicyWorkerDoc.getMetadataReferences());
            }
            if ((taskDataProcessingRecord = currentPolicyWorkerDoc.getPolicyDataProcessingRecord()) != null) {
                DocumentProcessingRecord newProcessingRecord = finalPolicyWorkerOutput.createPolicyDataProcessingRecord();
                newProcessingRecord.metadataChanges = taskDataProcessingRecord.metadataChanges;
                newProcessingRecord.referenceChange = taskDataProcessingRecord.referenceChange;
            }
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new GuavaModule());
        byte[] documentBytes = null;
        try {
            documentBytes = objectMapper.writeValueAsBytes((Object)finalPolicyWorkerOutput);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        com.github.cafdataprocessing.worker.policy.shared.Document documentToReconstitute = new com.github.cafdataprocessing.worker.policy.shared.Document();
        try {
            documentToReconstitute = (com.github.cafdataprocessing.worker.policy.shared.Document)objectMapper.readValue(documentBytes, com.github.cafdataprocessing.worker.policy.shared.Document.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            PolicyReprocessingDocumentBuilder.reconstituteOriginalDocument((DocumentInterface)documentToReconstitute);
        }
        catch (PolicyReprocessingReconstructMessageException e) {
            e.printStackTrace();
        }
        task.reconstitutedDocument = documentToReconstitute;
        task.workflowDocument = currentPolicyWorkerDoc;
        task.sharedDocument = new SharedDocumentConverter().convert(finalPolicyWorkerOutput);
        DataReproPolicyDefinition policyDefinition = (DataReproPolicyDefinition)new ObjectMapper().convertValue((Object)policy.details, DataReproPolicyDefinition.class);
        return new WorkerTaskResponsePolicyHandler.WorkerHandlerResponse((WorkerTaskResponsePolicyHandler)this, policyDefinition.queueName, TaskStatus.NEW_TASK, (Object)task, "Test", 1);
    }

    public PolicyType getPolicyType() {
        PolicyType policyType = new PolicyType();
        policyType.name = "Data Reprocessing Test PolicyType";
        policyType.shortName = "DataReproPolicyType";
        try {
            policyType.definition = new ObjectMapper().readTree(((Object)((Object)this)).getClass().getResource("/data-repro-policy-definition.json"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return policyType;
    }

    public Collection<Policy> resolve(Document document, Collection<Policy> collection) {
        return null;
    }

    class SharedDocumentConverter {
        SharedDocumentConverter() {
        }

        public SharedDocument convert(com.github.cafdataprocessing.worker.policy.shared.Document policyDocument) {
            SharedDocument newDocument = new SharedDocument();
            newDocument.setReference(policyDocument.getReference());
            if (policyDocument.getMetadata() != null) {
                newDocument.getMetadata().addAll(policyDocument.getMetadata().entries());
            }
            if (policyDocument.getMetadataReferences() != null) {
                newDocument.getMetadataReference().addAll(policyDocument.getMetadataReferences().entries());
            }
            if (policyDocument.getDocuments() != null) {
                newDocument.getChildDocuments().addAll(policyDocument.getDocuments().stream().map(this::convert).collect(Collectors.toList()));
            }
            newDocument.setDocumentProcessingRecord(policyDocument.getPolicyDataProcessingRecord());
            return newDocument;
        }
    }
}

