/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.worker.policy.testing.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.corepolicy.ProcessingAction;
import com.github.cafdataprocessing.corepolicy.common.Document;
import com.github.cafdataprocessing.corepolicy.common.dto.ConflictResolutionMode;
import com.github.cafdataprocessing.corepolicy.common.dto.Policy;
import com.github.cafdataprocessing.corepolicy.common.dto.PolicyType;
import com.github.cafdataprocessing.corepolicy.policy.TagPolicy.TagPolicy;
import com.github.cafdataprocessing.worker.policy.TagPolicyHandlerBase;
import com.github.cafdataprocessing.worker.policy.common.DocumentFields;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;

public class CheckTempFieldsWorkerHandler
extends TagPolicyHandlerBase {
    private static final String policyTypeJson = "{\n    \"properties\": {\n        \"fieldActions\": {\n            \"type\": \"array\",\n            \"items\": {\n                \"title\": \"Field Action\",\n                \"type\": \"object\",\n                \"properties\": {\n                    \"name\": {\n                        \"description\": \"The name of the field to perform the action on.\",\n                        \"type\": \"string\",\n                        \"minLength\": 1\n                    },\n                    \"action\": {\n                        \"description\": \"The type of action to perform on the field.\",\n                        \"type\": \"string\",\n                        \"enum\": [\n                            \"ADD_FIELD_VALUE\"\n                        ]\n                    },\n                    \"value\": {\n                        \"description\": \"The value to use for the field action.\",\n                        \"type\": \"string\"\n                    }\n                },\n                \"required\": [\"name\", \"action\"]\n            }\n        }\n    } \n}";

    public PolicyType getPolicyType() {
        PolicyType policyType = new PolicyType();
        policyType.conflictResolutionMode = ConflictResolutionMode.PRIORITY;
        ObjectMapper m = new ObjectMapper();
        JsonNode definition = null;
        try {
            definition = m.readTree(policyTypeJson);
        }
        catch (IOException e) {
            logger.error("Could not deserialize policy type definition", (Throwable)e);
        }
        policyType.definition = definition;
        policyType.name = "Test CheckForTempContextInfo Type";
        policyType.description = "Used to create test policies of type CheckForTempContextInfo";
        policyType.shortName = "TestHandlers-CheckForTempContextInfo";
        return policyType;
    }

    protected ProcessingAction handlePolicy(Document document, Policy policy, Long collectionSequenceId) {
        TagPolicy policy1 = this.getTagPolicy(policy);
        this.applyFieldActions(document, policy1.getFieldActions());
        Multimap metadata = document.getMetadata();
        boolean[] foundTmpFields = new boolean[]{false};
        DocumentFields.getListOfKnownTemporaryData((Multimap)metadata).stream().filter(propName -> metadata.containsKey(propName)).forEach(propName -> {
            blArray[0] = true;
        });
        metadata.put((Object)("CheckTempFieldsWorkerFoundMetadata_" + collectionSequenceId), (Object)Boolean.toString(foundTmpFields[0]));
        return ProcessingAction.CONTINUE_PROCESSING;
    }

    public Collection<Policy> resolve(Document document, Collection<Policy> policies) {
        return null;
    }
}

