/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.worker.policy.converter.qa;

import com.github.cafdataprocessing.worker.policy.converterinterface.PolicyWorkerConverterRuntime;
import com.github.cafdataprocessing.worker.policy.data.reprocessing.tracking.TrackedDocument;
import com.github.cafdataprocessing.worker.policy.shared.DocumentInterface;
import com.google.common.collect.Multimap;
import com.hpe.caf.api.Codec;
import com.hpe.caf.api.CodecException;
import com.hpe.caf.api.DecodeMethod;
import com.hpe.caf.api.worker.DataStore;
import com.hpe.caf.api.worker.TaskStatus;
import com.hpe.caf.api.worker.WorkerTaskData;

public final class TestWorkerConverterRuntimeImpl
implements PolicyWorkerConverterRuntime {
    private final TrackedDocument trackedDocument;
    private final Codec codec;
    private final DataStore dataStore;
    private final WorkerTaskData workerTask;

    public TestWorkerConverterRuntimeImpl(TrackedDocument trackedDocument, Codec codec, DataStore dataStore, WorkerTaskData workerTask) {
        this.trackedDocument = trackedDocument;
        this.codec = codec;
        this.dataStore = dataStore;
        this.workerTask = workerTask;
    }

    public TaskStatus getTaskStatus() {
        return this.workerTask.getStatus();
    }

    public DocumentInterface getDocument() {
        return this.trackedDocument;
    }

    public <T> T deserialiseData(Class<T> clazz) throws CodecException {
        byte[] data = this.workerTask.getData();
        return (T)this.codec.deserialise(data, clazz);
    }

    public <T> T deserialiseData(Class<T> clazz, DecodeMethod decodeMethod) throws CodecException {
        byte[] data = this.workerTask.getData();
        return (T)this.codec.deserialise(data, clazz, decodeMethod);
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public byte[] getData() {
        return this.workerTask.getData();
    }

    public void recordError(String errorCodeMessage) {
        Multimap documentMetadata = this.trackedDocument.getMetadata();
        documentMetadata.removeAll((Object)"POLICYWORKER_FAILURE_ERROR_CODE");
        documentMetadata.removeAll((Object)"POLICYWORKER_FAILURE_ERROR_MESSAGE");
        documentMetadata.put((Object)"POLICYWORKER_FAILURE_ERROR_CODE", (Object)errorCodeMessage);
        documentMetadata.put((Object)"POLICYWORKER_ERROR_CODE", (Object)errorCodeMessage);
    }

    public void recordError(String errorCode, String errorMessage) {
        Multimap documentMetadata = this.trackedDocument.getMetadata();
        documentMetadata.removeAll((Object)"POLICYWORKER_FAILURE_ERROR_CODE");
        documentMetadata.removeAll((Object)"POLICYWORKER_FAILURE_ERROR_MESSAGE");
        documentMetadata.put((Object)"POLICYWORKER_FAILURE_ERROR_CODE", (Object)errorCode);
        documentMetadata.put((Object)"POLICYWORKER_FAILURE_ERROR_MESSAGE", (Object)errorMessage);
        documentMetadata.put((Object)"POLICYWORKER_ERROR_CODE", (Object)errorCode);
        documentMetadata.put((Object)"POLICYWORKER_ERROR_MESSAGE", (Object)errorMessage);
    }
}

