/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.languagedetection;

import com.hpe.caf.api.ConfigurationException;
import com.hpe.caf.api.ConfigurationSource;
import com.hpe.caf.worker.document.extensibility.DocumentWorker;
import com.hpe.caf.worker.document.extensibility.DocumentWorkerFactory;
import com.hpe.caf.worker.document.model.Application;
import com.hpe.caf.worker.languagedetection.LanguageDetectionWorker;
import com.hpe.caf.worker.languagedetection.LanguageDetectionWorkerConfiguration;
import com.hpe.caf.worker.languagedetection.UnhealthyWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageDetectionWorkerFactory
implements DocumentWorkerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageDetectionWorkerFactory.class);

    public DocumentWorker createDocumentWorker(Application application) {
        LanguageDetectionWorkerConfiguration configuration;
        try {
            configuration = (LanguageDetectionWorkerConfiguration)((ConfigurationSource)application.getService(ConfigurationSource.class)).getConfiguration(LanguageDetectionWorkerConfiguration.class);
        }
        catch (ConfigurationException e) {
            LOG.error("Unable to retrieve worker configuration.", (Throwable)e);
            return new UnhealthyWorker("Unable to retrieve worker configuration. " + e.getMessage());
        }
        return new LanguageDetectionWorker(application, configuration);
    }
}

