/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.languagedetection;

import com.google.common.base.Strings;
import com.hpe.caf.languagedetection.LanguageDetector;
import com.hpe.caf.languagedetection.LanguageDetectorException;
import com.hpe.caf.languagedetection.LanguageDetectorProvider;
import com.hpe.caf.languagedetection.LanguageDetectorResult;
import com.hpe.caf.util.ModuleLoader;
import com.hpe.caf.util.ModuleLoaderException;
import com.hpe.caf.worker.document.exceptions.DocumentWorkerTransientException;
import com.hpe.caf.worker.document.extensibility.DocumentWorker;
import com.hpe.caf.worker.document.model.Application;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Field;
import com.hpe.caf.worker.document.model.HealthMonitor;
import com.hpe.caf.worker.languagedetection.LanguageDetectionException;
import com.hpe.caf.worker.languagedetection.LanguageDetectionResultFormat;
import com.hpe.caf.worker.languagedetection.LanguageDetectionUtilities;
import com.hpe.caf.worker.languagedetection.LanguageDetectionWorkerConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageDetectionWorker
implements DocumentWorker {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageDetectionWorker.class);
    private final LanguageDetectionWorkerConfiguration configuration;
    private final LanguageDetector languageDetector;

    public LanguageDetectionWorker(Application application, LanguageDetectionWorkerConfiguration configuration) {
        LanguageDetectorProvider provider;
        this.configuration = configuration;
        try {
            provider = (LanguageDetectorProvider)ModuleLoader.getService(LanguageDetectorProvider.class);
        }
        catch (ModuleLoaderException mle) {
            LOG.error("Failed to load module.");
            throw new LanguageDetectionException("Failed to load module.", mle);
        }
        try {
            this.languageDetector = provider.getLanguageDetector();
        }
        catch (LanguageDetectorException lde) {
            LOG.error("Failed to get language detector");
            throw new LanguageDetectionException("Failed to get language detector", lde);
        }
    }

    public void checkHealth(HealthMonitor healthMonitor) {
        if (this.languageDetector == null) {
            healthMonitor.reportUnhealthy("Language Detection Library unavailable.");
        }
    }

    public void processDocument(Document document) throws InterruptedException, DocumentWorkerTransientException {
        LanguageDetectionResultFormat resultFormat;
        try {
            resultFormat = this.getResultFormatToUse(document);
        }
        catch (IllegalArgumentException re) {
            LOG.error("Failed to read result format specified.");
            document.addFailure("LNG-InvalidResultFormat", re.getMessage());
            return;
        }
        try {
            String fields = document.getCustomData("fieldSpecs");
            if (fields == null) {
                String workerLangDetectSourceFieldEnv = System.getenv("WORKER_LANG_DETECT_SOURCE_FIELD");
                this.detectLanguage(document, Strings.isNullOrEmpty((String)workerLangDetectSourceFieldEnv) ? "CONTENT" : workerLangDetectSourceFieldEnv, false, resultFormat);
            } else {
                ArrayList<String> fieldsToDetect = new ArrayList<String>();
                for (String field : fields.split(",")) {
                    if (field.contains("*")) {
                        String fieldRegex = field.replace("*", "(.*)");
                        document.getFields().stream().forEach(documentField -> {
                            if (documentField.getName().toLowerCase(Locale.ENGLISH).matches(fieldRegex.toLowerCase(Locale.ENGLISH).trim())) {
                                fieldsToDetect.add(documentField.getName());
                            }
                        });
                        continue;
                    }
                    fieldsToDetect.add(field.trim());
                }
                if (fieldsToDetect.size() > 1 && LanguageDetectionResultFormat.isComplexFormat(resultFormat)) {
                    document.addFailure("LNG-InvalidCustomData", "Multiple fields are not supported on the 'fieldSpecs' task property when 'resultFormat' is set to a complex format.");
                    return;
                }
                for (String fieldName : fieldsToDetect) {
                    this.detectLanguage(document, fieldName.trim(), true, resultFormat);
                }
            }
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause instanceof IOException) {
                document.addFailure("LNG-GetDataFail", cause.getMessage());
            }
            throw re;
        }
        catch (LanguageDetectorException e) {
            LOG.error(e.getMessage());
            document.addFailure("LNG-LangDetectFail", e.getMessage());
        }
        catch (IOException ex) {
            LOG.debug("Failed to close InputStream.");
        }
    }

    private void detectLanguage(Document document, String fieldName, boolean inMultiFieldMode, LanguageDetectionResultFormat resultFormat) throws RuntimeException, LanguageDetectorException, IOException {
        LOG.debug("Document source data field to be used {}.", (Object)fieldName);
        Field sourceDataField = document.getField(fieldName);
        try (SequenceInputStream sequenceInputStream = LanguageDetectionUtilities.getFieldValuesAsStreams(sourceDataField);){
            LOG.debug("Perform language detection.");
            LanguageDetectorResult detectorResult = this.languageDetector.detectLanguage((InputStream)sequenceInputStream);
            if (detectorResult != null) {
                LanguageDetectionUtilities.addDetectedLanguageToDocument(detectorResult, document, sourceDataField, resultFormat, inMultiFieldMode);
            }
            LanguageDetectionUtilities.outputDocumentFieldValueChanges(document);
        }
    }

    private LanguageDetectionResultFormat getResultFormatToUse(Document document) throws IllegalArgumentException {
        String resultFormatStr = document.getCustomData("resultFormat");
        if (resultFormatStr == null) {
            return this.configuration.getResultFormat();
        }
        return LanguageDetectionResultFormat.valueOf(resultFormatStr.toUpperCase(Locale.ENGLISH));
    }
}

