/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.languagedetection;

import com.hpe.caf.languagedetection.DetectedLanguage;
import com.hpe.caf.languagedetection.LanguageDetectorResult;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Field;
import com.hpe.caf.worker.document.model.FieldValue;
import com.hpe.caf.worker.languagedetection.LanguageDetectionResultFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageDetectionUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageDetectionUtilities.class);

    private LanguageDetectionUtilities() {
    }

    public static SequenceInputStream getFieldValuesAsStreams(Field sourceDataField) throws RuntimeException {
        Objects.requireNonNull(sourceDataField);
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        for (FieldValue fv : sourceDataField.getValues()) {
            InputStream is = LanguageDetectionUtilities.getInputStream(fv);
            streams.add(is);
        }
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public static void addDetectedLanguagesToDocument(LanguageDetectorResult detectorResult, Document document) {
        Objects.requireNonNull(detectorResult);
        Objects.requireNonNull(document);
        LanguageDetectionUtilities.replaceDocumentField(document, "DetectedLanguages_Status", detectorResult.getLanguageDetectorStatus().toString());
        LanguageDetectionUtilities.replaceDocumentField(document, "DetectedLanguages_ReliableResult", String.valueOf(detectorResult.isReliable()));
        if (detectorResult.getLanguages() != null) {
            int languageId = 0;
            for (DetectedLanguage detectedLanguage : detectorResult.getLanguages()) {
                LanguageDetectionUtilities.replaceDocumentField(document, LanguageDetectionUtilities.getLanguageNameFieldName(++languageId), detectedLanguage.getLanguageName());
                LanguageDetectionUtilities.replaceDocumentField(document, LanguageDetectionUtilities.getLanguageCodeFieldName(languageId), detectedLanguage.getLanguageCode());
                LanguageDetectionUtilities.replaceDocumentField(document, LanguageDetectionUtilities.getLanguagePercentageFieldName(languageId), String.valueOf(detectedLanguage.getConfidencePercentage()));
            }
        }
    }

    public static void addDetectedLanguagesToDocument(LanguageDetectorResult detectorResult, Document document, String fieldName) {
        Objects.requireNonNull(detectorResult);
        Objects.requireNonNull(document);
        Objects.requireNonNull(fieldName);
        String field = LanguageDetectionUtilities.getLanguageFieldName(fieldName);
        boolean requiresUnknown = true;
        if (detectorResult.getLanguages() != null) {
            Field fieldToAdd = document.getField(field);
            fieldToAdd.clear();
            for (DetectedLanguage detectedLanguage : detectorResult.getLanguages()) {
                if (detectedLanguage.getLanguageCode().equals("un")) continue;
                fieldToAdd.add(detectedLanguage.getConfidencePercentage() + "% " + detectedLanguage.getLanguageCode());
                requiresUnknown = false;
            }
            if (requiresUnknown) {
                fieldToAdd.add("100% un");
            }
        }
    }

    public static void outputDocumentFieldValueChanges(Document document) {
        Objects.requireNonNull(document);
        String baseOutputDir = System.getenv("CAF_LANG_DETECT_WORKER_OUTPUT_FOLDER");
        String outputSubdir = document.getCustomData("outputSubfolder");
        if (baseOutputDir == null || baseOutputDir.isEmpty()) {
            LOG.debug("No response data output folder specified.");
            return;
        }
        LOG.debug("Outputting document field value changes.");
        Path outputFir = LanguageDetectionUtilities.getFullOutputPath(baseOutputDir, outputSubdir);
        File outputFile = LanguageDetectionUtilities.getFilePath(outputFir, document).toFile();
        document.getFields().forEach(field -> {
            try {
                LanguageDetectionUtilities.appendFieldValueChangesToFile(field, outputFile);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to output document field value changes", (Throwable)ioe);
            }
        });
    }

    public static void addDetectedLanguageToDocument(LanguageDetectorResult detectorResult, Document document, Field sourceDataField, LanguageDetectionResultFormat resultFormat, boolean inMultiFieldMode) throws RuntimeException {
        Objects.requireNonNull(detectorResult);
        Objects.requireNonNull(document);
        Objects.requireNonNull(sourceDataField);
        Objects.requireNonNull(resultFormat);
        if (resultFormat == LanguageDetectionResultFormat.SIMPLE) {
            if (inMultiFieldMode) {
                LOG.debug("Adding metadata to the document for each language detected in multi-field mode. Fields will be output in simple format.");
                LanguageDetectionUtilities.addDetectedLanguagesToDocument(detectorResult, document, sourceDataField.getName());
            } else {
                LOG.debug("Adding metadata to the document for each language detected. Fields will be output in simple format.");
                LanguageDetectionUtilities.addDetectedLanguagesToDocument(detectorResult, document);
            }
        } else if (LanguageDetectionResultFormat.isComplexFormat(resultFormat)) {
            LOG.debug("Adding metadata to the document for each language detected. Fields will be output in complex format.");
            LanguageDetectionUtilities.addDetectedLanguageToDocumentComplexMode(detectorResult, document, resultFormat);
        }
    }

    private static void addDetectedLanguageToDocumentComplexMode(LanguageDetectorResult detectorResult, Document document, LanguageDetectionResultFormat resultFormat) {
        Collection detectedLanguages = detectorResult.getLanguages();
        if (detectedLanguages == null || detectedLanguages.isEmpty()) {
            LOG.debug("No languages detected for the document.");
            return;
        }
        ArrayList<JSONObject> languageCodesToAdd = new ArrayList<JSONObject>();
        boolean unknownOnlyLanguageDetected = true;
        for (DetectedLanguage detectedLanguage : detectedLanguages) {
            String languageCode = detectedLanguage.getLanguageCode();
            if ("un".equals(languageCode)) continue;
            unknownOnlyLanguageDetected = false;
            languageCodesToAdd.add(LanguageDetectionUtilities.buildLanguageCodeEntry(languageCode, String.valueOf(detectedLanguage.getConfidencePercentage())));
        }
        if (unknownOnlyLanguageDetected) {
            languageCodesToAdd.add(LanguageDetectionUtilities.buildLanguageCodeEntry("un", "100"));
        }
        if (LanguageDetectionResultFormat.COMPLEX.equals((Object)resultFormat) || LanguageDetectionResultFormat.COMPLEX_COMBINED.equals((Object)resultFormat)) {
            JSONArray languageCodes = new JSONArray();
            languageCodesToAdd.stream().forEach(lc -> languageCodes.put(lc));
            LanguageDetectionUtilities.replaceDocumentField(document, "LANGUAGE_CODES", languageCodes.toString());
            return;
        }
        if (LanguageDetectionResultFormat.COMPLEX_SPLIT.equals((Object)resultFormat)) {
            Field langCodeField = document.getField("LANGUAGE_CODES");
            langCodeField.clear();
            languageCodesToAdd.stream().forEach(lc -> langCodeField.add(lc.toString()));
            return;
        }
        throw new RuntimeException("Unrecognized complex output format for language result. Format was: " + resultFormat.toString());
    }

    private static JSONObject buildLanguageCodeEntry(String languageCode, String confidence) {
        JSONObject languageCodeEntry = new JSONObject();
        languageCodeEntry.put("CODE", (Object)languageCode);
        languageCodeEntry.put("CONFIDENCE", (Object)confidence);
        return languageCodeEntry;
    }

    private static void replaceDocumentField(Document document, String name, String value) {
        LOG.debug("Replacing metadata field {} with value {} to the document.", (Object)name, (Object)value);
        document.getField(name).set(value);
    }

    private static InputStream getInputStream(FieldValue fieldValue) throws RuntimeException {
        try {
            return fieldValue.openInputStream();
        }
        catch (IOException ex) {
            LOG.error("Failed to acquire source data from the remote data store");
            throw new RuntimeException(ex);
        }
    }

    private static String getLanguageNameFieldName(int detectedLanguageId) {
        return "DetectedLanguage" + String.valueOf(detectedLanguageId) + "_" + "Name";
    }

    private static String getLanguageCodeFieldName(int detectedLanguageId) {
        return "DetectedLanguage" + String.valueOf(detectedLanguageId) + "_" + "Code";
    }

    private static String getLanguagePercentageFieldName(int detectedLanguageId) {
        return "DetectedLanguage" + String.valueOf(detectedLanguageId) + "_" + "ConfidencePercentage";
    }

    private static String getLanguageFieldName(String detectedLanguageField) {
        String languagePrefix = System.getenv("WORKER_LANG_DETECT_FIELD_PREFIX");
        if (languagePrefix == null) {
            return "LANGUAGE_CODE_" + detectedLanguageField;
        }
        return languagePrefix + detectedLanguageField;
    }

    private static Path getFullOutputPath(String outputDir, String outputSubdir) {
        return outputSubdir == null ? Paths.get(outputDir, new String[0]) : Paths.get(outputDir, outputSubdir);
    }

    private static Path getFilePath(Path dataOutputFolder, Document document) {
        String filenameField = LanguageDetectionUtilities.getFilenameField();
        String filename = document.getField(filenameField).getValues().stream().filter(fieldValue -> !fieldValue.isReference() && fieldValue.isStringValue()).map(FieldValue::getStringValue).filter(fieldValue -> {
            try {
                dataOutputFolder.resolve((String)fieldValue);
                return true;
            }
            catch (InvalidPathException ex) {
                return false;
            }
        }).findFirst().orElse("out.txt");
        return dataOutputFolder.resolve(filename);
    }

    private static String getFilenameField() {
        String filenameField = System.getenv("CAF_LANG_DETECT_WORKER_OUTPUT_FILENAME_FIELD");
        return filenameField == null || filenameField.isEmpty() ? "FILE_NAME" : filenameField;
    }

    private static void appendFieldValueChangesToFile(Field field, File dataOutputFile) throws IOException {
        if (field.hasChanges() && field.hasValues()) {
            for (FieldValue fv : field.getValues()) {
                if (fv.isReference()) continue;
                String changeValueDetails = field.getName() + ": " + fv.getStringValue() + "\r\n";
                FileUtils.writeStringToFile((File)dataOutputFile, (String)changeValueDetails, (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
        }
    }
}

