/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.languagedetection;

import com.hpe.caf.api.worker.DataStore;
import com.hpe.caf.api.worker.DataStoreException;
import com.hpe.caf.languagedetection.DetectedLanguage;
import com.hpe.caf.languagedetection.LanguageDetectorResult;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Field;
import com.hpe.caf.worker.document.model.FieldValue;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageDetectionUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageDetectionUtilities.class);

    private LanguageDetectionUtilities() {
    }

    public static SequenceInputStream getFieldValuesAsStreams(Field sourceDataField, DataStore dataStore) throws RuntimeException {
        Objects.requireNonNull(sourceDataField);
        Objects.requireNonNull(dataStore);
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        for (FieldValue fv : sourceDataField.getValues()) {
            InputStream is = LanguageDetectionUtilities.getInputStream(fv, dataStore);
            streams.add(is);
        }
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public static void addDetectedLanguagesToDocument(LanguageDetectorResult detectorResult, Document document) {
        Objects.requireNonNull(detectorResult);
        Objects.requireNonNull(document);
        LanguageDetectionUtilities.replaceDocumentField(document, "DetectedLanguages_Status", detectorResult.getLanguageDetectorStatus().toString());
        LanguageDetectionUtilities.replaceDocumentField(document, "DetectedLanguages_ReliableResult", String.valueOf(detectorResult.isReliable()));
        if (detectorResult.getLanguages() != null) {
            int languageId = 0;
            for (DetectedLanguage detectedLanguage : detectorResult.getLanguages()) {
                LanguageDetectionUtilities.replaceDocumentField(document, LanguageDetectionUtilities.getLanguageNameFieldName(++languageId), detectedLanguage.getLanguageName());
                LanguageDetectionUtilities.replaceDocumentField(document, LanguageDetectionUtilities.getLanguageCodeFieldName(languageId), detectedLanguage.getLanguageCode());
                LanguageDetectionUtilities.replaceDocumentField(document, LanguageDetectionUtilities.getLanguagePercentageFieldName(languageId), String.valueOf(detectedLanguage.getConfidencePercentage()));
            }
        }
    }

    public static void addDetectedLanguagesToDocument(LanguageDetectorResult detectorResult, Document document, String fieldName) {
        Objects.requireNonNull(detectorResult);
        Objects.requireNonNull(document);
        Objects.requireNonNull(fieldName);
        String field = LanguageDetectionUtilities.getLanguageFieldName(fieldName);
        if (document.getField(field).hasValues()) {
            document.getField(field).clear();
        }
        boolean requiresUnknown = true;
        if (detectorResult.getLanguages() != null) {
            Field fieldToAdd = document.getField(field);
            for (DetectedLanguage detectedLanguage : detectorResult.getLanguages()) {
                if (detectedLanguage.getLanguageCode().equals("un")) continue;
                fieldToAdd.add(detectedLanguage.getConfidencePercentage() + "% " + detectedLanguage.getLanguageCode());
                requiresUnknown = false;
            }
            if (requiresUnknown) {
                document.getField(field).add("100% un");
            }
        }
    }

    public static void outputDocumentFieldValueChanges(Document document) {
        Objects.requireNonNull(document);
        String baseOutputDir = System.getenv("CAF_LANG_DETECT_WORKER_OUTPUT_FOLDER");
        String outputSubdir = document.getCustomData("outputSubfolder");
        if (baseOutputDir == null || baseOutputDir.isEmpty()) {
            LOG.debug("No response data output folder specified.");
            return;
        }
        LOG.debug("Outputting document field value changes.");
        Path outputFir = LanguageDetectionUtilities.getFullOutputPath(baseOutputDir, outputSubdir);
        File outputFile = LanguageDetectionUtilities.getFilePath(outputFir, document).toFile();
        document.getFields().forEach(field -> {
            try {
                LanguageDetectionUtilities.appendFieldValueChangesToFile(field, outputFile);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to output document field value changes", (Throwable)ioe);
            }
        });
    }

    public static void addDetectedLanguageToDocument(LanguageDetectorResult detectorResult, Document document, Field sourceDataField, boolean inMultiFeildMode) {
        Objects.requireNonNull(detectorResult);
        Objects.requireNonNull(document);
        Objects.requireNonNull(sourceDataField);
        Objects.requireNonNull(inMultiFeildMode);
        if (inMultiFeildMode) {
            LOG.debug("Adding metadata to the document for each language detected.");
            LanguageDetectionUtilities.addDetectedLanguagesToDocument(detectorResult, document, sourceDataField.getName());
        } else {
            LOG.debug("Adding metadata to the document for each language detected.");
            LanguageDetectionUtilities.addDetectedLanguagesToDocument(detectorResult, document);
        }
    }

    private static void replaceDocumentField(Document document, String name, String value) {
        LOG.debug("Replacing metadata field {} with value {} to the document.", (Object)name, (Object)value);
        Field documentField = document.getField(name);
        documentField.clear();
        documentField.add(value);
    }

    private static InputStream getInputStream(FieldValue fieldValue, DataStore dataStore) throws RuntimeException {
        InputStream is;
        try {
            if (fieldValue.isReference()) {
                LOG.debug("Field value data is stored in the remote data store.");
                is = dataStore.retrieve(fieldValue.getReference());
            } else {
                LOG.debug("Field value data is local.");
                is = new ByteArrayInputStream(fieldValue.getValue());
            }
        }
        catch (DataStoreException dse) {
            LOG.error("Failed to acquire source data from the remote data store");
            throw new RuntimeException(dse);
        }
        return is;
    }

    private static String getLanguageNameFieldName(int detectedLanguageId) {
        return "DetectedLanguage" + String.valueOf(detectedLanguageId) + "_" + "Name";
    }

    private static String getLanguageCodeFieldName(int detectedLanguageId) {
        return "DetectedLanguage" + String.valueOf(detectedLanguageId) + "_" + "Code";
    }

    private static String getLanguagePercentageFieldName(int detectedLanguageId) {
        return "DetectedLanguage" + String.valueOf(detectedLanguageId) + "_" + "ConfidencePercentage";
    }

    private static String getLanguageFieldName(String detectedLanguageField) {
        String languagePrefix = System.getenv("WORKER_LANG_DETECT_FIELD_PREFIX");
        if (languagePrefix == null) {
            return "LANGUAGE_CODE_" + detectedLanguageField;
        }
        return languagePrefix + detectedLanguageField;
    }

    private static Path getFullOutputPath(String outputDir, String outputSubdir) {
        return outputSubdir == null ? Paths.get(outputDir, new String[0]) : Paths.get(outputDir, outputSubdir);
    }

    private static Path getFilePath(Path dataOutputFolder, Document document) {
        String filenameField = LanguageDetectionUtilities.getFilenameField();
        String filename = document.getField(filenameField).getValues().stream().filter(fieldValue -> !fieldValue.isReference() && fieldValue.isStringValue()).map(FieldValue::getStringValue).filter(fieldValue -> {
            try {
                dataOutputFolder.resolve((String)fieldValue);
                return true;
            }
            catch (InvalidPathException ex) {
                return false;
            }
        }).findFirst().orElse("out.txt");
        return dataOutputFolder.resolve(filename);
    }

    private static String getFilenameField() {
        String filenameField = System.getenv("CAF_LANG_DETECT_WORKER_OUTPUT_FILENAME_FIELD");
        return filenameField == null || filenameField.isEmpty() ? "FILE_NAME" : filenameField;
    }

    private static void appendFieldValueChangesToFile(Field field, File dataOutputFile) throws IOException {
        if (field.hasChanges() && field.hasValues()) {
            for (FieldValue fv : field.getValues()) {
                if (fv.isReference()) continue;
                String changeValueDetails = field.getName() + ": " + fv.getStringValue() + "\r\n";
                FileUtils.writeStringToFile((File)dataOutputFile, (String)changeValueDetails, (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
        }
    }
}

