/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document.testing;

import com.hpe.caf.api.Codec;
import com.hpe.caf.api.worker.DataStore;
import com.hpe.caf.codec.JsonCodec;
import com.hpe.caf.worker.datastore.mem.InMemoryDataStore;
import com.hpe.caf.worker.document.testing.CodeConfigurationSource;
import com.hpe.caf.worker.document.testing.DocumentWorkerConfigurationBuilder;
import java.util.Objects;

public class TestServices {
    private final DataStore dataStore;
    private final CodeConfigurationSource configurationSource;
    private final Codec codec;

    public TestServices(DataStore dataStore, CodeConfigurationSource configurationSource, Codec codec) {
        this.dataStore = Objects.requireNonNull(dataStore);
        this.configurationSource = Objects.requireNonNull(configurationSource);
        this.codec = Objects.requireNonNull(codec);
    }

    public static TestServices createDefault() {
        return new TestServices((DataStore)new InMemoryDataStore(), new CodeConfigurationSource(DocumentWorkerConfigurationBuilder.configure().withDefaults().build()), (Codec)new JsonCodec());
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public CodeConfigurationSource getConfigurationSource() {
        return this.configurationSource;
    }

    public Codec getCodec() {
        return this.codec;
    }
}

