/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document.testing;

import com.hpe.caf.worker.document.config.DocumentWorkerConfiguration;

public final class DocumentWorkerConfigurationBuilder {
    private final DocumentWorkerConfiguration configuration;

    private DocumentWorkerConfigurationBuilder(DocumentWorkerConfiguration configuration) {
        this.configuration = configuration;
    }

    public static DocumentWorkerConfigurationBuilder configure() {
        return DocumentWorkerConfigurationBuilder.configure(new DocumentWorkerConfiguration());
    }

    public static DocumentWorkerConfigurationBuilder configure(DocumentWorkerConfiguration documentWorkerConfiguration) {
        return new DocumentWorkerConfigurationBuilder(documentWorkerConfiguration);
    }

    public DocumentWorkerConfiguration build() {
        return this.configuration;
    }

    public DocumentWorkerConfigurationBuilder withDefaults() {
        this.configuration.setMaxBatchTime(1L);
        this.configuration.setMaxBatchTime(1L);
        this.configuration.setThreads(1);
        this.configuration.setOutputQueue("output-queue");
        this.configuration.setWorkerVersion("1.0.0");
        this.configuration.setWorkerName("worker-name");
        return this;
    }

    public DocumentWorkerConfigurationBuilder withOutputQueue(String outputQueue) {
        this.configuration.setOutputQueue(outputQueue);
        return this;
    }

    public DocumentWorkerConfigurationBuilder withThreads(int threads) {
        this.configuration.setThreads(threads);
        return this;
    }

    public DocumentWorkerConfigurationBuilder withMaxBatchSize(int maxBatchSize) {
        this.configuration.setMaxBatchSize(maxBatchSize);
        return this;
    }

    public DocumentWorkerConfigurationBuilder withMaxBatchTime(long maxBatchTime) {
        this.configuration.setMaxBatchTime(maxBatchTime);
        return this;
    }

    public DocumentWorkerConfigurationBuilder withWorkerName(String workerName) {
        this.configuration.setWorkerName(workerName);
        return this;
    }

    public DocumentWorkerConfigurationBuilder withWorkerVersion(String workerVersion) {
        this.configuration.setWorkerVersion(workerVersion);
        return this;
    }
}

