/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.worker.document.testing;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.hpe.caf.api.ConfigurationSource;
import com.hpe.caf.api.worker.WorkerException;
import com.hpe.caf.api.worker.WorkerTaskData;
import com.hpe.caf.worker.document.DocumentWorkerDocument;
import com.hpe.caf.worker.document.DocumentWorkerDocumentTask;
import com.hpe.caf.worker.document.DocumentWorkerFieldValue;
import com.hpe.caf.worker.document.exceptions.InvalidChangeLogException;
import com.hpe.caf.worker.document.exceptions.InvalidScriptException;
import com.hpe.caf.worker.document.impl.ApplicationImpl;
import com.hpe.caf.worker.document.impl.DocumentImpl;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.tasks.DocumentTask;
import com.hpe.caf.worker.document.testing.CustomDataBuilder;
import com.hpe.caf.worker.document.testing.FieldsBuilder;
import com.hpe.caf.worker.document.testing.TestServices;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.mockito.Mockito;

public final class DocumentBuilder {
    private final DocumentWorkerDocumentTask workerTask;
    private TestServices services;

    private DocumentBuilder(DocumentWorkerDocumentTask workerTask) {
        this.workerTask = workerTask;
        if (workerTask.document == null) {
            workerTask.document = new DocumentWorkerDocument();
        }
    }

    public static DocumentBuilder configure() {
        return new DocumentBuilder(new DocumentWorkerDocumentTask());
    }

    public static DocumentBuilder fromFile(String path) throws IOException {
        YAMLMapper mapper = new YAMLMapper();
        byte[] bytes = FileUtils.readFileToByteArray((File)new File(path));
        DocumentWorkerDocumentTask workerTask = (DocumentWorkerDocumentTask)mapper.readValue(bytes, DocumentWorkerDocumentTask.class);
        return new DocumentBuilder(workerTask);
    }

    public DocumentBuilder withReference(String reference) {
        this.workerTask.document.reference = reference;
        return this;
    }

    public DocumentBuilder withFields(Map<String, List<DocumentWorkerFieldValue>> fields) {
        this.workerTask.document.fields = fields;
        return this;
    }

    public FieldsBuilder withFields() {
        if (this.workerTask.document.fields == null) {
            this.workerTask.document.fields = new HashMap();
        }
        return new FieldsBuilder(this.workerTask.document.fields, this);
    }

    public CustomDataBuilder withCustomData() {
        if (this.workerTask.customData == null) {
            this.workerTask.customData = new HashMap();
        }
        return new CustomDataBuilder(this.workerTask.customData, this);
    }

    public DocumentBuilder withSubDocuments(DocumentBuilder ... documentBuilders) {
        if (documentBuilders == null) {
            return this;
        }
        if (this.workerTask.document.subdocuments == null) {
            this.workerTask.document.subdocuments = new ArrayList(documentBuilders.length);
        }
        for (DocumentBuilder documentBuilder : documentBuilders) {
            DocumentWorkerDocumentTask subDocumentTask = documentBuilder.workerTask;
            this.workerTask.document.subdocuments.add(subDocumentTask.document);
        }
        return this;
    }

    public DocumentBuilder withServices(TestServices testServices) {
        this.services = testServices;
        return this;
    }

    public Document build() throws WorkerException {
        DocumentTask documentWorkerTask;
        if (this.services == null) {
            this.services = TestServices.createDefault();
        }
        try {
            documentWorkerTask = DocumentTask.create((ApplicationImpl)new ApplicationImpl((ConfigurationSource)this.services.getConfigurationSource(), this.services.getDataStore(), this.services.getCodec()), (WorkerTaskData)((WorkerTaskData)Mockito.mock(WorkerTaskData.class)), (DocumentWorkerDocumentTask)this.workerTask);
        }
        catch (InvalidChangeLogException | InvalidScriptException e) {
            throw new RuntimeException("Failed to create document worker task.", e);
        }
        DocumentImpl document = documentWorkerTask.getDocument();
        return document;
    }
}

