/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.elastic.tools.cli;

import com.github.cafdataprocessing.elastic.tools.ElasticMappingUpdater;
import java.io.PrintStream;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="elastic-mapping-updater")
public final class Program
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Program.class);
    @CommandLine.Option(names={"-d", "--dryRun"}, paramLabel="<dryRun>", defaultValue="false", description={"If true, the tool lists the mapping changes to the indexes but does not apply them. Defaults to false."})
    private boolean dryRun;
    @CommandLine.Option(names={"-n", "--esHostNames"}, paramLabel="<esHostNames>", required=true, description={"Comma separated list of Elasticsearch hostnames"})
    private String esHostNames;
    @CommandLine.Option(names={"-p", "--esProtocol"}, paramLabel="<esProtocol>", defaultValue="http", description={"The protocol to connect with Elasticsearch server.  Default http"})
    private String esProtocol;
    @CommandLine.Option(names={"-r", "--esRestPort"}, paramLabel="<esRestPort>", defaultValue="9200", description={"Elasticsearch REST API port. Default 9200"})
    private int esRestPort;
    @CommandLine.Option(names={"-u", "--esUsername"}, paramLabel="<esUsername>", defaultValue="", description={"Elasticsearch username. Defaults to empty (anonymous access)"})
    private String esUsername;
    @CommandLine.Option(names={"-w", "--esPassword"}, paramLabel="<esPassword>", defaultValue="", description={"Elasticsearch password. Defaults to empty (anonymous access)"})
    private String esPassword;
    @CommandLine.Option(names={"-s", "--esConnectTimeout"}, paramLabel="<esConnectTimeout>", defaultValue="5000", description={"Determines the timeout until a new connection is fully established. Default 5000 (5 seconds)"})
    private int esConnectTimeout;
    @CommandLine.Option(names={"-t", "--esSocketTimeout"}, paramLabel="<esSocketTimeout>", defaultValue="60000", description={"This is the time of inactivity to wait for packets[data] to be received. Default 60000 (1 minute)"})
    private int esSocketTimeout;

    private Program() {
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new Program()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Void call() throws Exception {
        if (Objects.isNull(this.esHostNames)) {
            LOGGER.error("Elasticsearch hostname must be specified.");
            CommandLine.usage((Object)new Program(), (PrintStream)System.out);
        } else {
            ElasticMappingUpdater.update((boolean)this.dryRun, (String)this.esHostNames, (String)this.esProtocol, (int)this.esRestPort, (String)this.esUsername, (String)this.esPassword, (int)this.esConnectTimeout, (int)this.esSocketTimeout);
        }
        return null;
    }
}

