/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.opensearch.indices.validate_query.IndicesValidationExplanation;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ValidateQueryResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ValidateQueryResponse> {
    @Nullable
    private final String error;
    @Nonnull
    private final List<IndicesValidationExplanation> explanations;
    @Nullable
    private final ShardStatistics shards;
    private final boolean valid;
    public static final JsonpDeserializer<ValidateQueryResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ValidateQueryResponse::setupValidateQueryResponseDeserializer);

    private ValidateQueryResponse(Builder builder) {
        this.error = builder.error;
        this.explanations = ApiTypeHelper.unmodifiable(builder.explanations);
        this.shards = builder.shards;
        this.valid = ApiTypeHelper.requireNonNull(builder.valid, this, "valid");
    }

    public static ValidateQueryResponse of(Function<Builder, ObjectBuilder<ValidateQueryResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String error() {
        return this.error;
    }

    @Nonnull
    public final List<IndicesValidationExplanation> explanations() {
        return this.explanations;
    }

    @Nullable
    public final ShardStatistics shards() {
        return this.shards;
    }

    public final boolean valid() {
        return this.valid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.error != null) {
            generator.writeKey("error");
            generator.write(this.error);
        }
        if (ApiTypeHelper.isDefined(this.explanations)) {
            generator.writeKey("explanations");
            generator.writeStartArray();
            for (IndicesValidationExplanation item0 : this.explanations) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
        generator.writeKey("valid");
        generator.write(this.valid);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupValidateQueryResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::error, JsonpDeserializer.stringDeserializer(), "error");
        op.add(Builder::explanations, JsonpDeserializer.arrayDeserializer(IndicesValidationExplanation._DESERIALIZER), "explanations");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::valid, JsonpDeserializer.booleanDeserializer(), "valid");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.error);
        result = 31 * result + Objects.hashCode(this.explanations);
        result = 31 * result + Objects.hashCode(this.shards);
        result = 31 * result + Boolean.hashCode(this.valid);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidateQueryResponse other = (ValidateQueryResponse)o;
        return Objects.equals(this.error, other.error) && Objects.equals(this.explanations, other.explanations) && Objects.equals(this.shards, other.shards) && this.valid == other.valid;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ValidateQueryResponse> {
        @Nullable
        private String error;
        @Nullable
        private List<IndicesValidationExplanation> explanations;
        @Nullable
        private ShardStatistics shards;
        private Boolean valid;

        public Builder() {
        }

        private Builder(ValidateQueryResponse o) {
            this.error = o.error;
            this.explanations = Builder._listCopy(o.explanations);
            this.shards = o.shards;
            this.valid = o.valid;
        }

        private Builder(Builder o) {
            this.error = o.error;
            this.explanations = Builder._listCopy(o.explanations);
            this.shards = o.shards;
            this.valid = o.valid;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder error(@Nullable String value) {
            this.error = value;
            return this;
        }

        @Nonnull
        public final Builder explanations(List<IndicesValidationExplanation> list) {
            this.explanations = Builder._listAddAll(this.explanations, list);
            return this;
        }

        @Nonnull
        public final Builder explanations(IndicesValidationExplanation value, IndicesValidationExplanation ... values) {
            this.explanations = Builder._listAdd(this.explanations, value, values);
            return this;
        }

        @Nonnull
        public final Builder explanations(Function<IndicesValidationExplanation.Builder, ObjectBuilder<IndicesValidationExplanation>> fn) {
            return this.explanations(fn.apply(new IndicesValidationExplanation.Builder()).build(), new IndicesValidationExplanation[0]);
        }

        @Nonnull
        public final Builder shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this;
        }

        @Nonnull
        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Nonnull
        public final Builder valid(boolean value) {
            this.valid = value;
            return this;
        }

        @Override
        @Nonnull
        public ValidateQueryResponse build() {
            this._checkSingleUse();
            return new ValidateQueryResponse(this);
        }
    }
}

