/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.TemplatesResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class TemplatesRequest
extends CatRequestBase
implements ToCopyableBuilder<Builder, TemplatesRequest> {
    @Nullable
    private final Time clusterManagerTimeout;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String name;
    public static final Endpoint<TemplatesRequest, TemplatesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TemplatesRequest, TemplatesResponse>(request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_cat/templates";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat/templates/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, TemplatesResponse._DESERIALIZER);

    private TemplatesRequest(Builder builder) {
        super(builder);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.masterTimeout = builder.masterTimeout;
        this.name = builder.name;
    }

    public static TemplatesRequest of(Function<Builder, ObjectBuilder<TemplatesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplatesRequest other = (TemplatesRequest)o;
        return Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.name, other.name);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TemplatesRequest> {
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String name;

        public Builder() {
        }

        private Builder(TemplatesRequest o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.masterTimeout = o.masterTimeout;
            this.name = o.name;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.masterTimeout = o.masterTimeout;
            this.name = o.name;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        @Nonnull
        public TemplatesRequest build() {
            this._checkSingleUse();
            return new TemplatesRequest(this);
        }
    }
}

