/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafapi.logging.common;

import com.github.cafapi.common.util.processidentifier.ProcessIdentifier;
import java.util.Locale;

public final class ProcessAndThreadIdProvider {
    private static final String PROCESS_ID = ProcessIdentifier.getProcessId().toString().substring(0, 3);
    private static final ThreadLocal<String> threadIds = ThreadLocal.withInitial(ProcessAndThreadIdProvider::getThreadName);

    private ProcessAndThreadIdProvider() {
    }

    private static String getThreadName() {
        long threadId = Thread.currentThread().getId();
        return String.format(Locale.ENGLISH, "#%s.%03d", PROCESS_ID, threadId);
    }

    public static String getId() {
        return threadIds.get();
    }
}

