/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafapi.logging.common;

import java.util.regex.Pattern;

public final class LogMessageValidator {
    private static final Pattern DISALLOWED_CHARACTERS = Pattern.compile("[^\\w-.]");

    private LogMessageValidator() {
    }

    public static boolean isMessageSafeToLog(String message) {
        if (message.isEmpty()) {
            return true;
        }
        if (message.charAt(0) == '{') {
            return false;
        }
        return message.chars().allMatch(c -> c >= 32 && c < 127);
    }

    public static String sanitizeMessage(String message) {
        return DISALLOWED_CHARACTERS.matcher(message).replaceAll("");
    }
}

