/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.elastic.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.elastic.tools.ElasticMappingUpdaterConfiguration;
import com.github.cafdataprocessing.elastic.tools.ElasticProvider;
import com.github.cafdataprocessing.elastic.tools.exceptions.GetIndexException;
import com.github.cafdataprocessing.elastic.tools.exceptions.GetTemplatesException;
import com.github.cafdataprocessing.elastic.tools.exceptions.UnexpectedResponseException;
import com.google.common.net.UrlEscapers;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.opensearch.client.Request;
import org.opensearch.client.Response;
import org.opensearch.client.ResponseException;
import org.opensearch.client.RestClient;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.indices.GetTemplateResponse;
import org.opensearch.client.opensearch.indices.TemplateMapping;
import org.opensearch.client.util.ApiTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElasticRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticRequestHandler.class);
    private final RestClient elasticClient;
    private final ObjectMapper objectMapper;

    public ElasticRequestHandler(ElasticMappingUpdaterConfiguration schemaUpdaterConfig, ObjectMapper mapper) {
        this.objectMapper = mapper;
        this.elasticClient = ElasticProvider.getClient(schemaUpdaterConfig.getElasticSettings());
    }

    Map<String, TemplateMapping> getTemplates() throws IOException, GetTemplatesException, ParseException {
        LOGGER.debug("Getting templates...");
        Request request = new Request("GET", "/_template");
        Response response = this.elasticClient.performRequest(request);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            try (InputStream resultJsonStream = response.getEntity().getContent();){
                Map map;
                block13: {
                    JsonParser jsonValueParser = Json.createParser((InputStream)resultJsonStream);
                    try {
                        ApiTypeHelper.DANGEROUS_disableRequiredPropertiesCheck((boolean)true);
                        GetTemplateResponse getTemplatesResponse = (GetTemplateResponse)GetTemplateResponse._DESERIALIZER.deserialize(jsonValueParser, (JsonpMapper)new JacksonJsonpMapper());
                        Map indexTemplates = getTemplatesResponse.result();
                        ApiTypeHelper.DANGEROUS_disableRequiredPropertiesCheck((boolean)false);
                        map = indexTemplates;
                        if (jsonValueParser == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (jsonValueParser != null) {
                            try {
                                jsonValueParser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    jsonValueParser.close();
                }
                return map;
            }
        }
        throw new GetTemplatesException(String.format("Error getting templates. Status code: %s, response: %s", statusCode, EntityUtils.toString((HttpEntity)response.getEntity())));
    }

    List<String> getIndexNames(List<String> indexNamePatterns) throws UnexpectedResponseException, IOException, ParseException {
        LOGGER.debug("Getting index names matching pattern(s) : {}...", indexNamePatterns);
        if (indexNamePatterns == null || indexNamePatterns.isEmpty()) {
            return Collections.emptyList();
        }
        String filter = "/" + String.join((CharSequence)",", indexNamePatterns);
        Request request = new Request("GET", filter);
        try {
            JsonNode responseNode = this.performRequest(request);
            Iterable fieldNames = () -> responseNode.fieldNames();
            return StreamSupport.stream(fieldNames.spliterator(), false).sorted().collect(Collectors.toList());
        }
        catch (ResponseException e) {
            int statusCode = e.getResponse().getStatusLine().getStatusCode();
            if (statusCode == 404) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    public TypeMapping getIndexMapping(String indexName) throws IOException, GetIndexException, ParseException {
        LOGGER.debug("Getting index mapping for: {}...", (Object)indexName);
        Request request = new Request("GET", "/" + UrlEscapers.urlPathSegmentEscaper().escape(indexName));
        Response response = this.elasticClient.performRequest(request);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(EntityUtils.toString((HttpEntity)response.getEntity())));
            JsonObject mappings = jsonReader.readObject().getJsonObject(indexName).getJsonObject("mappings");
            JsonParser jsonMappingParser = Json.createParser((Reader)new StringReader(mappings.toString()));
            ApiTypeHelper.DANGEROUS_disableRequiredPropertiesCheck((boolean)true);
            TypeMapping mapping = (TypeMapping)TypeMapping._DESERIALIZER.deserialize(jsonMappingParser, (JsonpMapper)new JacksonJsonpMapper());
            ApiTypeHelper.DANGEROUS_disableRequiredPropertiesCheck((boolean)false);
            return mapping;
        }
        throw new GetIndexException(String.format("Error getting index '%s'. Status code: %s, response: %s", indexName, statusCode, EntityUtils.toString((HttpEntity)response.getEntity())));
    }

    boolean updateIndexMapping(String indexName, Map<String, Object> mappings) throws IOException, UnexpectedResponseException, ParseException {
        JsonNode responseNode;
        LOGGER.debug("Updating mapping of index {} with these changes {}...", (Object)indexName, mappings);
        String mappingSource = this.objectMapper.writeValueAsString(mappings);
        Request request = new Request("PUT", "/" + UrlEscapers.urlPathSegmentEscaper().escape(indexName) + "/_mapping");
        request.setJsonEntity(mappingSource);
        Response response = this.elasticClient.performRequest(request);
        HttpEntity responseEntity = response.getEntity();
        ContentType contentType = ContentType.parse((CharSequence)responseEntity.getContentType());
        if (contentType == null) {
            throw new UnexpectedResponseException("Failed to get the content type from the response entity");
        }
        if (!ContentType.APPLICATION_JSON.getMimeType().equals(contentType.getMimeType())) {
            throw new UnexpectedResponseException("JSON response expected but response type was " + contentType.getMimeType());
        }
        JsonNode jsonNode = responseNode = StandardCharsets.UTF_8.equals(contentType.getCharset()) ? this.objectMapper.readTree(responseEntity.getContent()) : this.objectMapper.readTree(EntityUtils.toString((HttpEntity)responseEntity));
        if (responseNode == null) {
            throw new UnexpectedResponseException("JSON response deserialized to null");
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return true;
        }
        LOGGER.error("Index Mapping upadate status : {}", (Object)statusCode);
        return false;
    }

    private JsonNode performRequest(Request request) throws UnexpectedResponseException, IOException, ParseException {
        JsonNode responseNode;
        Response response = this.elasticClient.performRequest(request);
        HttpEntity responseEntity = response.getEntity();
        ContentType contentType = ContentType.parse((CharSequence)responseEntity.getContentType());
        if (contentType == null) {
            throw new UnexpectedResponseException("Failed to get the content type from the response entity");
        }
        if (!ContentType.APPLICATION_JSON.getMimeType().equals(contentType.getMimeType())) {
            throw new UnexpectedResponseException("JSON response expected but response type was " + contentType.getMimeType());
        }
        JsonNode jsonNode = responseNode = StandardCharsets.UTF_8.equals(contentType.getCharset()) ? this.objectMapper.readTree(responseEntity.getContent()) : this.objectMapper.readTree(EntityUtils.toString((HttpEntity)responseEntity));
        if (responseNode == null) {
            throw new UnexpectedResponseException("JSON response deserialized to null");
        }
        return responseNode;
    }
}

