/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.elastic.tools;

import com.github.cafdataprocessing.elastic.tools.ElasticSettings;
import jakarta.annotation.Nonnull;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Timeout;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;

final class ElasticProvider {
    ElasticProvider() {
    }

    @Nonnull
    public static RestClient getClient(ElasticSettings elasticSettings) {
        String scheme = elasticSettings.getElasticSearchProtocol();
        String[] hosts = elasticSettings.getElasticSearchHosts().split(",");
        HttpHost[] eshosts = new HttpHost[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            eshosts[i] = new HttpHost(scheme, hosts[i].trim(), elasticSettings.getElasticSearchRestPort());
        }
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])eshosts);
        restClientBuilder.setRequestConfigCallback(builder -> builder.setConnectTimeout(Timeout.of((long)elasticSettings.getElasticSearchConnectTimeout(), (TimeUnit)TimeUnit.SECONDS)).setResponseTimeout(Timeout.of((long)elasticSettings.getElasticSearchSocketTimeout(), (TimeUnit)TimeUnit.SECONDS)));
        String username = elasticSettings.getElasticSearchUsername();
        String password = elasticSettings.getElasticSearchPassword();
        if (ElasticProvider.credentialsSupplied(username, password)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
            restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider));
        }
        return restClientBuilder.build();
    }

    private static boolean credentialsSupplied(String username, String password) {
        return username != null && !username.trim().isEmpty() && password != null;
    }
}

