/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.elastic.tools;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.elastic.tools.ElasticMappingUpdaterConfiguration;
import com.github.cafdataprocessing.elastic.tools.ElasticRequestHandler;
import com.github.cafdataprocessing.elastic.tools.ElasticSettings;
import com.github.cafdataprocessing.elastic.tools.exceptions.GetIndexException;
import com.github.cafdataprocessing.elastic.tools.exceptions.GetTemplatesException;
import com.github.cafdataprocessing.elastic.tools.exceptions.UnexpectedResponseException;
import com.github.cafdataprocessing.elastic.tools.utils.FlatMapUtil;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ParseException;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.jackson.JacksonJsonpGenerator;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.indices.TemplateMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticMappingUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticMappingUpdater.class);
    private static final String MAPPING_PROPS_KEY = "properties";
    private static final String MAPPING_DYNAMIC_TEMPLATES_KEY = "dynamic_templates";
    private static final String MAPPING_TYPE_KEY = "type";
    private final ObjectMapper mapper = new ObjectMapper();
    private static final Set<String> MODIFIABLE_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("boost", "coerce", "copy_to", "eager_global_ordinals", "fielddata", "fields", "ignore_above", "ignore_malformed", "meta", "properties", "search_analyzer", "search_quote_analyzer")));
    private final ObjectMapper objectMapper;
    private final ElasticRequestHandler elasticRequestHandler;
    private final boolean dryRun;

    public static void update(boolean dryRun, String esHostNames, String esProtocol, int esRestPort, String esUsername, String esPassword, int esConnectTimeout, int esSocketTimeout) throws IOException, GetIndexException, GetTemplatesException, UnexpectedResponseException, ParseException {
        ElasticMappingUpdater updater = new ElasticMappingUpdater(dryRun, esHostNames, esProtocol, esRestPort, esUsername, esPassword, esConnectTimeout, esSocketTimeout);
        LOGGER.info("Updating indexes on '{}'. {}", (Object)esHostNames, (Object)(dryRun ? "This is a dry run. No indexes will actually be updated." : "Indexes with no mapping conflicts will be updated."));
        updater.updateIndexes();
    }

    private ElasticMappingUpdater(boolean dryRun, String esHostNames, String esProtocol, int esRestPort, String esUsername, String esPassword, int esConnectTimeout, int esSocketTimeout) {
        this.dryRun = dryRun;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        ElasticSettings elasticSettings = new ElasticSettings(esProtocol, esHostNames, esRestPort, esUsername, esPassword, esConnectTimeout, esSocketTimeout);
        ElasticMappingUpdaterConfiguration schemaUpdaterConfiguration = new ElasticMappingUpdaterConfiguration(elasticSettings);
        this.elasticRequestHandler = new ElasticRequestHandler(schemaUpdaterConfiguration, this.objectMapper);
    }

    private void updateIndexes() throws IOException, GetIndexException, GetTemplatesException, UnexpectedResponseException, ParseException {
        Map<String, TemplateMapping> templates = this.elasticRequestHandler.getTemplates();
        LOGGER.info("Templates found in Elasticsearch: {}", templates.keySet());
        for (Map.Entry<String, TemplateMapping> template : templates.entrySet()) {
            this.updateIndexesForTemplate(template.getKey(), template.getValue());
        }
    }

    private void updateIndexesForTemplate(String templateName, TemplateMapping template) throws IOException, GetIndexException, UnexpectedResponseException, ParseException {
        LOGGER.info("---- Analyzing indexes matching template '{}' ----", (Object)templateName);
        List patterns = template.indexPatterns();
        TypeMapping mapping = template.mappings();
        if (mapping == null) {
            LOGGER.info("No mappings in template '{}'. Indexes for this template will not be updated.", (Object)templateName);
            return;
        }
        Map<String, Object> templateProperties = this.getObjectAsHashMap(mapping.properties());
        List<String> indexes = this.elasticRequestHandler.getIndexNames(patterns);
        LOGGER.info("Found {} index(es) that match template '{}'", (Object)indexes.size(), (Object)templateName);
        for (String indexName : indexes) {
            boolean indexNeedsUpdates;
            Object t2;
            TypeMapping indexMappings = this.elasticRequestHandler.getIndexMapping(indexName);
            Map<String, Object> indexProperties = this.getObjectAsHashMap(indexMappings.properties());
            LOGGER.info("Comparing index mapping for '{}'", (Object)indexName);
            Map<String, Object> mappingsChanges = this.getMappingChanges(templateProperties, indexProperties);
            HashMap<String, Object> mappingsRequest = new HashMap<String, Object>();
            mappingsRequest.put(MAPPING_PROPS_KEY, mappingsChanges);
            ArrayList<Object> dynamicTemplatesInTemplate = new ArrayList<Object>();
            for (Object t2 : mapping.dynamicTemplates()) {
                dynamicTemplatesInTemplate.add(this.getObjectAsHashMap((Map<String, ? extends JsonpSerializable>)t2));
            }
            ArrayList<Object> dynamicTemplatesInIndex = new ArrayList<Object>();
            t2 = indexMappings.dynamicTemplates().iterator();
            while (t2.hasNext()) {
                Map t3 = (Map)t2.next();
                dynamicTemplatesInIndex.add(this.getObjectAsHashMap(t3));
            }
            ArrayList dynamicTemplatesUpdates = new ArrayList(dynamicTemplatesInTemplate);
            LOGGER.debug("Dynamic_templates: current: {} target: {}", dynamicTemplatesInIndex, dynamicTemplatesInTemplate);
            boolean dynamicTemplatesHaveChanged = this.hasDynamicTemplateChanged(dynamicTemplatesInTemplate, dynamicTemplatesInIndex);
            LOGGER.info("{}", (Object)(dynamicTemplatesHaveChanged ? "Current dynamic_templates will be replaced with updated version." : "No dynamic_template changes required."));
            mappingsRequest.put(MAPPING_DYNAMIC_TEMPLATES_KEY, dynamicTemplatesUpdates);
            LOGGER.info("'{}' comparison complete.", (Object)indexName);
            boolean bl = indexNeedsUpdates = !mappingsChanges.isEmpty() || dynamicTemplatesHaveChanged;
            if (!indexNeedsUpdates) {
                LOGGER.info("No index mapping changes required.");
            }
            if (this.dryRun || !indexNeedsUpdates) continue;
            LOGGER.info("Updating index mapping...");
            this.elasticRequestHandler.updateIndexMapping(indexName, mappingsRequest);
            LOGGER.info("Index mapping updated");
        }
        LOGGER.info("---- Analysis of indexes matching template '{}' completed ----", (Object)templateName);
    }

    private static boolean isMappingChangeSafe(Map<String, Object> templateMapping, Map<String, Object> indexMapping, Set<String> allowedFieldDifferences, Set<String> unSupportedFieldDifferences) throws JsonProcessingException {
        boolean safeChangesOnly;
        Map<String, Object> findexMapping;
        Map<String, Object> ftemplateMapping = FlatMapUtil.flatten(templateMapping);
        MapDifference diff = Maps.difference(ftemplateMapping, findexMapping = FlatMapUtil.flatten(indexMapping));
        Map entriesDiffering = diff.entriesDiffering();
        if (entriesDiffering.isEmpty()) {
            safeChangesOnly = true;
        } else {
            entriesDiffering.forEach((key, value) -> {
                LOGGER.warn("Unsupported mapping change : {} - current: {} target: {}", new Object[]{key, value.rightValue(), value.leftValue()});
                if (key.contains(MAPPING_PROPS_KEY)) {
                    unSupportedFieldDifferences.add((String)key);
                } else {
                    allowedFieldDifferences.remove(ElasticMappingUpdater.getFieldName(key));
                }
            });
            safeChangesOnly = false;
        }
        HashSet unsupportedParamChanges = new HashSet();
        Map entriesOnlyInIndex = diff.entriesOnlyOnRight();
        entriesOnlyInIndex.entrySet().stream().filter(e -> ElasticMappingUpdater.isUnsupportedParam((String)e.getKey())).forEach(e -> {
            LOGGER.warn("Unsupported mapping change-field parameter being removed : {}:{}", e.getKey(), e.getValue());
            unsupportedParamChanges.add((String)e.getKey());
        });
        Set<String> existingFields = findexMapping.keySet();
        Map entriesOnlyInTemplate = diff.entriesOnlyOnLeft();
        entriesOnlyInTemplate.entrySet().stream().filter(e -> ElasticMappingUpdater.isExistingField(existingFields, ElasticMappingUpdater.getFullFieldName((String)e.getKey()))).filter(e -> ElasticMappingUpdater.isUnsupportedParam((String)e.getKey())).forEach(e -> {
            LOGGER.warn("Unsupported mapping change-field parameter being added : {}", e.getKey());
            unsupportedParamChanges.add((String)e.getKey());
        });
        if (!unsupportedParamChanges.isEmpty()) {
            unSupportedFieldDifferences.addAll(unsupportedParamChanges);
            safeChangesOnly = false;
        }
        return safeChangesOnly;
    }

    private static boolean isExistingField(Set<String> existingFields, String key) {
        LOGGER.trace("Checking if {} is an existing field {}", (Object)key, existingFields);
        return existingFields.stream().filter(e -> e.startsWith(key)).count() != 0L;
    }

    private static boolean isUnsupportedParam(String fieldPath) {
        String paramName = ElasticMappingUpdater.getParamName(fieldPath);
        LOGGER.trace("Checking if param {} is modifiable", (Object)paramName);
        return !MODIFIABLE_PROPERTIES.contains(paramName);
    }

    private static String getFieldName(String key) {
        LOGGER.trace("Get field name for {}", (Object)key);
        return key.split(Pattern.quote("/"))[1];
    }

    private static String getFullFieldName(String key) {
        LOGGER.trace("Get full field name for {}", (Object)key);
        String[] path = key.split(Pattern.quote("/"));
        if (key.contains(MAPPING_PROPS_KEY)) {
            String paramName = path[path.length - 1];
            return key.replace(paramName, "");
        }
        return "/" + path[1];
    }

    private static String getParamName(String key) {
        LOGGER.trace("Get param name from {}", (Object)key);
        String[] path = key.split(Pattern.quote("/"));
        return path[path.length - 1];
    }

    private Map<String, Object> getMappingChanges(Map<String, Object> templateMapping, Map<String, Object> indexMapping) throws JsonProcessingException {
        HashMap<String, Object> mappingsChanges = new HashMap<String, Object>();
        MapDifference diff = Maps.difference(templateMapping, indexMapping);
        Map entriesDiffering = diff.entriesDiffering();
        HashSet<String> allowedFieldDifferences = new HashSet<String>(entriesDiffering.keySet());
        HashSet<String> unSupportedFieldDifferences = new HashSet<String>();
        boolean unsupportedObjectChanges = false;
        if (!entriesDiffering.isEmpty()) {
            LOGGER.info("--Differences between template and index mapping--");
            entriesDiffering.forEach((key, value) -> LOGGER.info("  {} - current: {} target: {}", new Object[]{key, value.rightValue(), value.leftValue()}));
            Iterator typeDifferences = entriesDiffering.entrySet().stream().filter(e -> ((Map)((MapDifference.ValueDifference)e.getValue()).leftValue()).containsKey(MAPPING_PROPS_KEY) && (!((Map)((MapDifference.ValueDifference)e.getValue()).leftValue()).get(MAPPING_TYPE_KEY).equals("object") || !((Map)((MapDifference.ValueDifference)e.getValue()).rightValue()).get(MAPPING_TYPE_KEY).equals("object"))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (MapDifference.ValueDifference)e.getValue()));
            if (!typeDifferences.isEmpty()) {
                typeDifferences.forEach((key, value) -> {
                    LOGGER.warn("Unsupported object/nested mapping change : {} - current: {} target: {}", new Object[]{key, value.rightValue(), value.leftValue()});
                    allowedFieldDifferences.remove(key);
                });
                unsupportedObjectChanges = true;
            }
        }
        if (!ElasticMappingUpdater.isMappingChangeSafe(templateMapping, indexMapping, allowedFieldDifferences, unSupportedFieldDifferences) || unsupportedObjectChanges) {
            LOGGER.warn("Unsupported mapping changes will not be applied to the index.");
        }
        LOGGER.info("{}", allowedFieldDifferences.isEmpty() ? "No other allowed changes required to existing properties." : "Properties to be changed: " + allowedFieldDifferences);
        for (String field : allowedFieldDifferences) {
            mappingsChanges.put(field, ((MapDifference.ValueDifference)entriesDiffering.get(field)).leftValue());
        }
        LOGGER.info("{}", unSupportedFieldDifferences.isEmpty() ? "No unsupported field changes." : "Unsupported field changes that will not be included in the update: " + unSupportedFieldDifferences);
        for (String field : unSupportedFieldDifferences) {
            if (field.contains(MAPPING_PROPS_KEY)) {
                this.removeUnsupportedFieldChange(mappingsChanges, field);
                continue;
            }
            mappingsChanges.remove(ElasticMappingUpdater.getFieldName(field));
        }
        Map entriesOnlyInTemplate = diff.entriesOnlyOnLeft();
        Set newProperties = entriesOnlyInTemplate.keySet();
        LOGGER.info("{}", newProperties.isEmpty() ? "No new properties to add." : "Properties to be added: " + newProperties);
        mappingsChanges.putAll(entriesOnlyInTemplate);
        return mappingsChanges;
    }

    private boolean hasDynamicTemplateChanged(List<Object> dynamicTemplatesInTemplate, List<Object> dynamicTemplatesInIndex) {
        if (dynamicTemplatesInTemplate.size() != dynamicTemplatesInIndex.size()) {
            return true;
        }
        return dynamicTemplatesInTemplate.retainAll(dynamicTemplatesInIndex);
    }

    private void removeUnsupportedFieldChange(Map<String, Object> mappingsChanges, String fieldPath) {
        List<String> path = Arrays.asList(StringUtils.split((String)fieldPath.trim(), (String)"/"));
        int size = path.size();
        int index = 0;
        if (size == 2) {
            String fieldName = path.get(0);
            mappingsChanges.remove(fieldName);
        } else {
            while (index != size - 2) {
                int i = index++;
                String currentFieldName = path.get(i);
                if (!path.contains(MAPPING_PROPS_KEY)) {
                    mappingsChanges.remove(currentFieldName);
                    break;
                }
                Object field = mappingsChanges.get(path.get(i));
                if (!(field instanceof Map)) continue;
                Map currentField = (Map)field;
                String subPath = fieldPath.substring(fieldPath.indexOf(currentFieldName) + currentFieldName.length());
                this.removeUnsupportedFieldChange(currentField, subPath);
            }
        }
    }

    private Map<String, Object> getObjectAsHashMap(Map<String, ? extends JsonpSerializable> obj) throws JsonProcessingException, IOException {
        LinkedHashMap<String, Object> mapFromString = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ? extends JsonpSerializable> val : obj.entrySet()) {
            String result = "{\"" + val.getKey() + "\":" + this.getStringFromObject(val.getValue()) + "}";
            mapFromString.putAll((Map)this.mapper.readValue(result, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        return mapFromString;
    }

    private String getStringFromObject(JsonpSerializable value) throws IOException {
        StringWriter writer = new StringWriter();
        try (JacksonJsonpGenerator generator = new JacksonJsonpGenerator(new JsonFactory().createGenerator((Writer)writer));){
            value.serialize((JsonGenerator)generator, (JsonpMapper)new JacksonJsonpMapper());
        }
        return writer.toString();
    }
}

