/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafapi.logging.logback.converters;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.pattern.RootCauseFirstThrowableProxyConverter;
import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.github.cafapi.logging.common.JsonFactoryCreator;
import com.github.cafapi.logging.common.LogMessageValidator;
import com.github.cafapi.logging.common.UnexpectedIOException;
import com.github.cafapi.logging.logback.converters.CustomThrowableProxyConverter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.text.StrBuilder;

public final class MaybeJsonMessageConverter
extends ThrowableHandlingConverter {
    private static final JsonFactory jsonFactory = JsonFactoryCreator.create();
    private static final String HYPHEN = "-";
    private ClassicConverter throwableConverter;

    public void start() {
        List optionList = this.getOptionList();
        String packages = MaybeJsonMessageConverter.getPackages(optionList);
        String maxLines = MaybeJsonMessageConverter.getMaxStackTraceLines(optionList);
        this.throwableConverter = null != packages || null != maxLines ? new CustomThrowableProxyConverter(packages, maxLines) : new RootCauseFirstThrowableProxyConverter();
        this.throwableConverter.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this.throwableConverter.stop();
    }

    public String convert(ILoggingEvent event) {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        String message = event.getFormattedMessage();
        if (throwableProxy == null && LogMessageValidator.isMessageSafeToLog((String)message)) {
            return message;
        }
        StrBuilder sb = new StrBuilder();
        try (JsonGenerator jsonBuilder = jsonFactory.createGenerator(sb.asWriter());){
            jsonBuilder.writeStartObject();
            jsonBuilder.writeStringField("message", message);
            if (throwableProxy != null) {
                jsonBuilder.writeStringField("exception", this.throwableConverter.convert((Object)event));
            }
            jsonBuilder.writeEndObject();
        }
        catch (IOException ex) {
            throw new UnexpectedIOException(ex);
        }
        return sb.toString();
    }

    private static String getMaxStackTraceLines(List<String> optionList) {
        String s;
        if (Objects.nonNull(optionList) && 1 < optionList.size() && (s = optionList.get(1)).equals(HYPHEN)) {
            return null;
        }
        return null;
    }

    private static String getPackages(List<String> optionList) {
        if (Objects.nonNull(optionList) && !optionList.isEmpty()) {
            String s = optionList.get(0);
            if (s.equals(HYPHEN)) {
                return null;
            }
            return s;
        }
        return null;
    }
}

