/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafapi.logging.logback.converters;

import ch.qos.logback.classic.pattern.RootCauseFirstThrowableProxyConverter;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class CustomThrowableProxyConverter
extends RootCauseFirstThrowableProxyConverter {
    private final List<String> filteredPackages;
    private final int maxStackTraceSize;

    public CustomThrowableProxyConverter(String packages, String maxLines) {
        this.filteredPackages = CustomThrowableProxyConverter.getFilteredPackages(packages);
        this.maxStackTraceSize = CustomThrowableProxyConverter.getMaxStackTraceSize(maxLines);
    }

    private static List<String> getFilteredPackages(String packages) {
        List<String> filteredPackages = null != packages && !packages.isEmpty() ? Arrays.asList(packages.split(";")) : Collections.emptyList();
        return filteredPackages;
    }

    private static int getMaxStackTraceSize(String maxLines) {
        try {
            return Integer.parseInt(maxLines);
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    protected void subjoinSTEPArray(StringBuilder buf, int indent, IThrowableProxy tp) {
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        int stackTracePrinted = 0;
        for (int i = 0; i < stepArray.length && stackTracePrinted < this.maxStackTraceSize; ++i) {
            StackTraceElementProxy step = stepArray[i];
            StackTraceElement ste = step.getStackTraceElement();
            if (!this.isIncludedPackage(ste.getClassName())) continue;
            if (0 < stackTracePrinted) {
                buf.append(CoreConstants.LINE_SEPARATOR);
            }
            ThrowableProxyUtil.indent((StringBuilder)buf, (int)indent);
            buf.append(step);
            ++stackTracePrinted;
        }
        if (0 < tp.getCommonFrames() && stackTracePrinted < this.maxStackTraceSize) {
            ThrowableProxyUtil.indent((StringBuilder)buf, (int)indent);
            buf.append("... ").append(tp.getCommonFrames()).append(" more");
            buf.append(CoreConstants.LINE_SEPARATOR);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isIncludedPackage(String className) {
        if (this.filteredPackages.isEmpty()) return true;
        if (!this.filteredPackages.stream().anyMatch(className::startsWith)) return false;
        return true;
    }
}

