/*
 * Decompiled with CFR 0.152.
 */
package com.byeongukchoi.oauth2.server.grant;

import com.byeongukchoi.oauth2.server.dto.AuthorizationRequestDto;
import com.byeongukchoi.oauth2.server.dto.TokenDto;
import com.byeongukchoi.oauth2.server.entity.AccessToken;
import com.byeongukchoi.oauth2.server.entity.RefreshToken;
import com.byeongukchoi.oauth2.server.grant.AbstractGrant;
import com.byeongukchoi.oauth2.server.repository.AccessTokenRepository;
import com.byeongukchoi.oauth2.server.repository.RefreshTokenRepository;

public class RefreshTokenGrant
extends AbstractGrant {
    private AccessTokenRepository accessTokenRepository;
    private RefreshTokenRepository refreshTokenRepository;

    public RefreshTokenGrant(AccessTokenRepository accessTokenRepository, RefreshTokenRepository refreshTokenRepository) {
        this.accessTokenRepository = accessTokenRepository;
        this.refreshTokenRepository = refreshTokenRepository;
    }

    @Override
    public TokenDto issueToken(AuthorizationRequestDto authorizationRequestDto) throws Exception {
        RefreshToken refreshToken = this.refreshTokenRepository.findByTokenAndClientId(authorizationRequestDto.getRefreshToken(), authorizationRequestDto.getClientId());
        if (refreshToken == null) {
            throw new Exception("Not Found Token");
        }
        if (refreshToken.isExpired().booleanValue()) {
            throw new Exception("Expired Code");
        }
        AccessToken accessToken = this.accessTokenRepository.getNewToken();
        RefreshToken newRefreshToken = this.refreshTokenRepository.getNewToken();
        this.accessTokenRepository.saveNewToken(accessToken);
        this.refreshTokenRepository.saveNewToken(newRefreshToken);
        TokenDto tokenDto = TokenDto.builder().accessToken(accessToken.getToken()).refreshToken(refreshToken.getToken()).build();
        return tokenDto;
    }
}

