/*
 * Decompiled with CFR 0.152.
 */
package com.byeongukchoi.oauth2.server.grant;

import com.byeongukchoi.oauth2.server.dto.AuthorizationRequestDto;
import com.byeongukchoi.oauth2.server.dto.TokenDto;
import com.byeongukchoi.oauth2.server.entity.AccessToken;
import com.byeongukchoi.oauth2.server.entity.AuthorizationCode;
import com.byeongukchoi.oauth2.server.entity.RefreshToken;
import com.byeongukchoi.oauth2.server.grant.AbstractGrant;
import com.byeongukchoi.oauth2.server.repository.AccessTokenRepository;
import com.byeongukchoi.oauth2.server.repository.AuthorizationCodeRepository;
import com.byeongukchoi.oauth2.server.repository.RefreshTokenRepository;

public class AuthorizationCodeGrant
extends AbstractGrant {
    private AuthorizationCodeRepository authorizationCodeRepository;
    private AccessTokenRepository accessTokenRepository;
    private RefreshTokenRepository refreshTokenRepository;

    public AuthorizationCodeGrant(AuthorizationCodeRepository authorizationCodeRepository, AccessTokenRepository accessTokenRepository, RefreshTokenRepository refreshTokenRepository) {
        this.authorizationCodeRepository = authorizationCodeRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.refreshTokenRepository = refreshTokenRepository;
    }

    @Override
    public TokenDto issueToken(AuthorizationRequestDto authorizationRequestDto) throws Exception {
        AuthorizationCode authorizationCode = this.authorizationCodeRepository.findByCodeAndClientId(authorizationRequestDto.getCode(), authorizationRequestDto.getClientId());
        if (authorizationCode == null) {
            throw new Exception("Not Found Code");
        }
        if (authorizationCode.isExpired().booleanValue()) {
            throw new Exception("Expired Code");
        }
        AccessToken accessToken = this.accessTokenRepository.getNewToken();
        RefreshToken refreshToken = this.refreshTokenRepository.getNewToken();
        this.accessTokenRepository.saveNewToken(accessToken);
        this.refreshTokenRepository.saveNewToken(refreshToken);
        TokenDto tokenDto = TokenDto.builder().accessToken(accessToken.getToken()).refreshToken(refreshToken.getToken()).build();
        return tokenDto;
    }
}

