/*
 * Decompiled with CFR 0.152.
 */
package com.byeongukchoi.oauth2.server.dto;

public class TokenDto {
    private String tokenType;
    private String accessToken;
    private int expiresIn;
    private String refreshToken;
    private int refreshTokenExpiresIn;
    private String scope;

    TokenDto(String tokenType, String accessToken, int expiresIn, String refreshToken, int refreshTokenExpiresIn, String scope) {
        this.tokenType = tokenType;
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.refreshToken = refreshToken;
        this.refreshTokenExpiresIn = refreshTokenExpiresIn;
        this.scope = scope;
    }

    public static TokenDtoBuilder builder() {
        return new TokenDtoBuilder();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public int getRefreshTokenExpiresIn() {
        return this.refreshTokenExpiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public static class TokenDtoBuilder {
        private String tokenType;
        private String accessToken;
        private int expiresIn;
        private String refreshToken;
        private int refreshTokenExpiresIn;
        private String scope;

        TokenDtoBuilder() {
        }

        public TokenDtoBuilder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public TokenDtoBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public TokenDtoBuilder expiresIn(int expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public TokenDtoBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public TokenDtoBuilder refreshTokenExpiresIn(int refreshTokenExpiresIn) {
            this.refreshTokenExpiresIn = refreshTokenExpiresIn;
            return this;
        }

        public TokenDtoBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public TokenDto build() {
            return new TokenDto(this.tokenType, this.accessToken, this.expiresIn, this.refreshToken, this.refreshTokenExpiresIn, this.scope);
        }

        public String toString() {
            return "TokenDto.TokenDtoBuilder(tokenType=" + this.tokenType + ", accessToken=" + this.accessToken + ", expiresIn=" + this.expiresIn + ", refreshToken=" + this.refreshToken + ", refreshTokenExpiresIn=" + this.refreshTokenExpiresIn + ", scope=" + this.scope + ")";
        }
    }
}

