/*
 * Decompiled with CFR 0.152.
 */
package com.byeongukchoi.oauth2.server.application.dto;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.NonNull;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class TokenDto {
    private String tokenType;
    private String accessToken;
    private int expiresIn;
    private String refreshToken;
    private int refreshTokenExpiresIn;
    private String scope;

    public TokenDto(String tokenType, @NonNull String accessToken, int expiresIn, @NonNull String refreshToken, int refreshTokenExpiresIn) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked non-null but is null");
        }
        this.tokenType = tokenType;
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.refreshToken = refreshToken;
        this.refreshTokenExpiresIn = refreshTokenExpiresIn;
    }

    public static TokenDtoBuilder builder() {
        return new TokenDtoBuilder();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public int getRefreshTokenExpiresIn() {
        return this.refreshTokenExpiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setRefreshTokenExpiresIn(int refreshTokenExpiresIn) {
        this.refreshTokenExpiresIn = refreshTokenExpiresIn;
    }

    public static class TokenDtoBuilder {
        private String tokenType;
        private String accessToken;
        private int expiresIn;
        private String refreshToken;
        private int refreshTokenExpiresIn;

        TokenDtoBuilder() {
        }

        public TokenDtoBuilder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public TokenDtoBuilder accessToken(@NonNull String accessToken) {
            if (accessToken == null) {
                throw new NullPointerException("accessToken is marked non-null but is null");
            }
            this.accessToken = accessToken;
            return this;
        }

        public TokenDtoBuilder expiresIn(int expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public TokenDtoBuilder refreshToken(@NonNull String refreshToken) {
            if (refreshToken == null) {
                throw new NullPointerException("refreshToken is marked non-null but is null");
            }
            this.refreshToken = refreshToken;
            return this;
        }

        public TokenDtoBuilder refreshTokenExpiresIn(int refreshTokenExpiresIn) {
            this.refreshTokenExpiresIn = refreshTokenExpiresIn;
            return this;
        }

        public TokenDto build() {
            return new TokenDto(this.tokenType, this.accessToken, this.expiresIn, this.refreshToken, this.refreshTokenExpiresIn);
        }

        public String toString() {
            return "TokenDto.TokenDtoBuilder(tokenType=" + this.tokenType + ", accessToken=" + this.accessToken + ", expiresIn=" + this.expiresIn + ", refreshToken=" + this.refreshToken + ", refreshTokenExpiresIn=" + this.refreshTokenExpiresIn + ")";
        }
    }
}

