/*
 * Decompiled with CFR 0.152.
 */
package com.byeongukchoi.oauth2.server.application;

import com.byeongukchoi.oauth2.server.application.AbstractGrant;
import com.byeongukchoi.oauth2.server.application.dto.AuthorizationRequestDto;
import com.byeongukchoi.oauth2.server.application.dto.TokenDto;
import com.byeongukchoi.oauth2.server.domain.AccessToken;
import com.byeongukchoi.oauth2.server.domain.RefreshToken;
import com.byeongukchoi.oauth2.server.domain.repository.AccessTokenRepository;
import com.byeongukchoi.oauth2.server.domain.repository.RefreshTokenRepository;
import com.byeongukchoi.oauth2.server.error.exception.ErrorCode;
import com.byeongukchoi.oauth2.server.error.exception.OAuth2ServerException;

public class RefreshTokenGrant
extends AbstractGrant {
    private AccessTokenRepository<AccessToken, String> accessTokenRepository;
    private RefreshTokenRepository<RefreshToken, String> refreshTokenRepository;

    public RefreshTokenGrant(AccessTokenRepository<AccessToken, String> accessTokenRepository, RefreshTokenRepository<RefreshToken, String> refreshTokenRepository) {
        this.accessTokenRepository = accessTokenRepository;
        this.refreshTokenRepository = refreshTokenRepository;
    }

    @Override
    public TokenDto issueToken(AuthorizationRequestDto authorizationRequestDto) throws OAuth2ServerException {
        RefreshToken refreshToken = this.refreshTokenRepository.findByTokenAndClientId(authorizationRequestDto.getRefreshToken(), authorizationRequestDto.getClientId());
        if (refreshToken == null) {
            throw new OAuth2ServerException(ErrorCode.NOT_FOUND_REFRESH_TOKEN);
        }
        if (refreshToken.isExpired()) {
            throw new OAuth2ServerException(ErrorCode.EXPIRED_REFRESH_TOKEN);
        }
        authorizationRequestDto.setUsername(refreshToken.getUsername());
        AccessToken accessToken = this.accessTokenRepository.getNewToken(authorizationRequestDto);
        RefreshToken newRefreshToken = this.refreshTokenRepository.getNewToken(authorizationRequestDto, accessToken.getToken());
        this.accessTokenRepository.saveNewToken(accessToken);
        this.refreshTokenRepository.saveNewToken(newRefreshToken);
        TokenDto tokenDto = TokenDto.builder().accessToken(accessToken.getToken()).expiresIn(accessToken.getExpiresIn()).refreshToken(newRefreshToken.getToken()).refreshTokenExpiresIn(refreshToken.getExpiresIn()).build();
        this.refreshTokenRepository.expireToken(refreshToken);
        return tokenDto;
    }
}

