/*
 * Decompiled with CFR 0.152.
 */
package com.byeongukchoi.oauth2.server.application;

import com.byeongukchoi.oauth2.server.application.AbstractGrant;
import com.byeongukchoi.oauth2.server.application.dto.AuthorizationRequestDto;
import com.byeongukchoi.oauth2.server.application.dto.TokenDto;
import com.byeongukchoi.oauth2.server.domain.AccessToken;
import com.byeongukchoi.oauth2.server.domain.AuthorizationCode;
import com.byeongukchoi.oauth2.server.domain.RefreshToken;
import com.byeongukchoi.oauth2.server.domain.repository.AccessTokenRepository;
import com.byeongukchoi.oauth2.server.domain.repository.AuthorizationCodeRepository;
import com.byeongukchoi.oauth2.server.domain.repository.RefreshTokenRepository;
import com.byeongukchoi.oauth2.server.error.exception.ErrorCode;
import com.byeongukchoi.oauth2.server.error.exception.OAuth2ServerException;

public class AuthorizationCodeGrant
extends AbstractGrant {
    private AuthorizationCodeRepository<AuthorizationCode, String> authorizationCodeRepository;
    private AccessTokenRepository<AccessToken, String> accessTokenRepository;
    private RefreshTokenRepository<RefreshToken, String> refreshTokenRepository;

    public AuthorizationCodeGrant(AuthorizationCodeRepository<AuthorizationCode, String> authorizationCodeRepository, AccessTokenRepository<AccessToken, String> accessTokenRepository, RefreshTokenRepository<RefreshToken, String> refreshTokenRepository) {
        this.authorizationCodeRepository = authorizationCodeRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.refreshTokenRepository = refreshTokenRepository;
    }

    @Override
    public TokenDto issueToken(AuthorizationRequestDto authorizationRequestDto) throws OAuth2ServerException {
        AuthorizationCode authorizationCode = this.authorizationCodeRepository.findByCodeAndClientId(authorizationRequestDto.getCode(), authorizationRequestDto.getClientId());
        if (authorizationCode == null) {
            throw new OAuth2ServerException(ErrorCode.NOT_FOUND_AUTHORIZATION_CODE);
        }
        if (authorizationCode.isExpired()) {
            throw new OAuth2ServerException(ErrorCode.EXPIRED_AUTHORIZATION_CODE);
        }
        authorizationRequestDto.setUsername(authorizationCode.getUsername());
        AccessToken accessToken = this.accessTokenRepository.getNewToken(authorizationRequestDto);
        RefreshToken refreshToken = this.refreshTokenRepository.getNewToken(authorizationRequestDto, accessToken.getToken());
        this.accessTokenRepository.saveNewToken(accessToken);
        this.refreshTokenRepository.saveNewToken(refreshToken);
        TokenDto tokenDto = TokenDto.builder().accessToken(accessToken.getToken()).expiresIn(accessToken.getExpiresIn()).refreshToken(refreshToken.getToken()).refreshTokenExpiresIn(refreshToken.getExpiresIn()).build();
        this.authorizationCodeRepository.expireCode(authorizationCode);
        return tokenDto;
    }
}

