/*
 * Decompiled with CFR 0.152.
 */
package com.github.flylib.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/github/flylib/util/UUIDByteConverter;", "", "()V", "Companion", "flylib-module"})
public final class UUIDByteConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/github/flylib/util/UUIDByteConverter$Companion;", "", "()V", "getBytesFromUUID", "", "uuid", "Ljava/util/UUID;", "getUUIDFromBytes", "bytes", "flylib-module"})
    public static final class Companion {
        @NotNull
        public final byte[] getBytesFromUUID(@NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "ByteBuffer.wrap(ByteArray(16))");
            ByteBuffer bb = byteBuffer;
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            byte[] byArray = bb.array();
            Intrinsics.checkNotNullExpressionValue(byArray, "bb.array()");
            return byArray;
        }

        @NotNull
        public final UUID getUUIDFromBytes(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "ByteBuffer.wrap(bytes)");
            ByteBuffer byteBuffer2 = byteBuffer;
            long high = byteBuffer2.getLong();
            long low = byteBuffer2.getLong();
            return new UUID(high, low);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

