/*
 * Decompiled with CFR 0.152.
 */
package com.github.flylib.util;

import com.github.flylib.util.FlatEntry;
import com.github.flylib.util.FlatList;
import com.github.flylib.util.IndexOutOfSizeException;
import com.github.flylib.util.NaturalNumber;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J#\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/github/flylib/util/SizedFlatList;", "K", "", "width", "Lcom/github/flylib/util/NaturalNumber;", "height", "(Lcom/github/flylib/util/NaturalNumber;Lcom/github/flylib/util/NaturalNumber;)V", "flatList", "Lcom/github/flylib/util/FlatList;", "getHeight", "()Lcom/github/flylib/util/NaturalNumber;", "getWidth", "get", "Lcom/github/flylib/util/FlatEntry;", "x", "y", "getForce", "outCheck", "", "set", "t", "(Lcom/github/flylib/util/NaturalNumber;Lcom/github/flylib/util/NaturalNumber;Ljava/lang/Object;)V", "flylib-module"})
public final class SizedFlatList<K> {
    private FlatList<K> flatList;
    @NotNull
    private final NaturalNumber width;
    @NotNull
    private final NaturalNumber height;

    public final void set(@NotNull NaturalNumber x, @NotNull NaturalNumber y, K t) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        this.outCheck(x, y);
        this.flatList.setEntry(x.getI(), y.getI(), t);
    }

    @Nullable
    public final FlatEntry<K> get(@NotNull NaturalNumber x, @NotNull NaturalNumber y) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        this.outCheck(x, y);
        return this.flatList.getEntry(x.getI(), y.getI());
    }

    @NotNull
    public final FlatEntry<K> getForce(@NotNull NaturalNumber x, @NotNull NaturalNumber y) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        this.outCheck(x, y);
        return this.flatList.getEntryForce(x.getI(), y.getI());
    }

    public final void outCheck(@NotNull NaturalNumber x, @NotNull NaturalNumber y) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        if (this.width.compareTo(x.getI()) < 0) {
            throw (Throwable)new IndexOutOfSizeException(x.getI(), y.getI(), this.width.getI(), this.height.getI());
        }
        if (this.height.compareTo(y.getI()) < 0) {
            throw (Throwable)new IndexOutOfSizeException(x.getI(), y.getI(), this.width.getI(), this.height.getI());
        }
    }

    @NotNull
    public final NaturalNumber getWidth() {
        return this.width;
    }

    @NotNull
    public final NaturalNumber getHeight() {
        return this.height;
    }

    public SizedFlatList(@NotNull NaturalNumber width, @NotNull NaturalNumber height) {
        Intrinsics.checkNotNullParameter(width, "width");
        Intrinsics.checkNotNullParameter(height, "height");
        this.width = width;
        this.height = height;
        this.flatList = new FlatList();
    }
}

