/*
 * Decompiled with CFR 0.152.
 */
package com.github.bun133.flyframe;

import com.github.bun133.flyframe.EventHandler;
import com.github.bun133.flyframe.FlyModulePlugin;
import com.github.bun133.flyframe.Module;
import com.github.bun133.flyframe.ModuleEvent;
import com.github.bun133.flyframe.command.Commands;
import com.github.bun133.flyframe.util.MessageSendable;
import com.github.bun133.flyframe.util.SeverSendable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000bJ\u0010\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/github/bun133/flyframe/FlyFrame;", "Lorg/bukkit/plugin/java/JavaPlugin;", "()V", "eventHandler", "Lcom/github/bun133/flyframe/EventHandler;", "getEventHandler", "()Lcom/github/bun133/flyframe/EventHandler;", "setEventHandler", "(Lcom/github/bun133/flyframe/EventHandler;)V", "modules", "", "Lcom/github/bun133/flyframe/Module;", "getModules", "()Ljava/util/List;", "modulesFolder", "Ljava/io/File;", "getModulesFolder", "()Ljava/io/File;", "setModulesFolder", "(Ljava/io/File;)V", "isModuleExits", "", "name", "", "onDisable", "", "onEnable", "registerModule", "module", "reloadModules", "se", "Lcom/github/bun133/flyframe/util/MessageSendable;", "removeModule", "requireModule", "flyframe"})
public final class FlyFrame
extends JavaPlugin {
    public File modulesFolder;
    @NotNull
    private final List<Module> modules;
    public EventHandler eventHandler;

    @NotNull
    public final File getModulesFolder() {
        File file = this.modulesFolder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException("modulesFolder");
        }
        return file;
    }

    public final void setModulesFolder(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "<set-?>");
        this.modulesFolder = file;
    }

    @NotNull
    public final List<Module> getModules() {
        return this.modules;
    }

    @NotNull
    public final EventHandler getEventHandler() {
        EventHandler eventHandler = this.eventHandler;
        if (eventHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException("eventHandler");
        }
        return eventHandler;
    }

    public final void setEventHandler(@NotNull EventHandler eventHandler) {
        Intrinsics.checkNotNullParameter(eventHandler, "<set-?>");
        this.eventHandler = eventHandler;
    }

    public void onEnable() {
        this.eventHandler = new EventHandler(this);
        new Commands(this).onEnable();
        File file = this.modulesFolder = new File(this.getDataFolder(), "modules");
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException("modulesFolder");
        }
        if (!file.exists()) {
            File file2 = this.modulesFolder;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("modulesFolder");
            }
            file2.mkdirs();
        } else {
            this.reloadModules(new SeverSendable());
        }
    }

    public void onDisable() {
        Iterable $this$forEach$iv = this.modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module it = (Module)element$iv;
            boolean bl = false;
            it.onModuleEnable();
        }
    }

    public final void reloadModules(@NotNull MessageSendable se) {
        Intrinsics.checkNotNullParameter(se, "se");
        File file = this.modulesFolder;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException("modulesFolder");
        }
        File[] files = file.listFiles();
        String string = "[FlyFrame] " + files.length + " Files";
        boolean bl = false;
        System.out.println((Object)string);
        int loadedPluginCount = 0;
        Intrinsics.checkNotNullExpressionValue(files, "files");
        File[] $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        File[] fileArray = $this$forEach$iv;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File it = element$iv = fileArray[i];
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append("FileName:");
            File file2 = it;
            Intrinsics.checkNotNullExpressionValue(file2, "it");
            String string2 = stringBuilder.append(file2.getName()).toString();
            boolean bl3 = false;
            System.out.println((Object)string2);
            Plugin p = null;
            boolean shouldSkipLoad = false;
            try {
                p = this.getPluginLoader().loadPlugin(it);
            }
            catch (InvalidPluginException e) {
                se.send(it.getName() + " is not valid plugin file");
                shouldSkipLoad = true;
            }
            catch (UnknownDependencyException e) {
                se.send(it.getName() + " requires unknown plugin");
                shouldSkipLoad = true;
            }
            catch (Exception e) {
                se.send("Unknown Error Occurred!");
                String string3 = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue(string3, "e.localizedMessage");
                se.send(string3);
                shouldSkipLoad = true;
            }
            if (shouldSkipLoad) continue;
            if (p instanceof FlyModulePlugin) {
                Module module = ((FlyModulePlugin)p).getModule();
                if (!this.registerModule(module)) {
                    se.send("Error Occurred While registering " + module.getModuleName() + " Module");
                    continue;
                }
                int n2 = loadedPluginCount;
                loadedPluginCount = n2 + 1;
                continue;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            Plugin plugin = p;
            Intrinsics.checkNotNull(plugin);
            se.send(stringBuilder2.append(plugin.getName()).append(" is not valid fly-module-plugin!").toString());
        }
        EventHandler eventHandler = this.eventHandler;
        if (eventHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException("eventHandler");
        }
        eventHandler.execute(ModuleEvent.LOADED_ALL_MODULE);
        se.send("[FlyFrame] " + loadedPluginCount + " Modules Loaded!");
    }

    public final boolean registerModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter(module, "module");
        try {
            boolean bl;
            Object $this$any$iv;
            block6: {
                $this$any$iv = this.modules;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        Module it = (Module)element$iv;
                        boolean bl2 = false;
                        if (!(it.getModuleName() == module.getModuleName())) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                $this$any$iv = "[FlyFrame] ModuleName:" + module.getModuleName() + " is Already Exits!";
                boolean bl3 = false;
                System.out.println($this$any$iv);
                return false;
            }
            this.modules.add(module);
            module.onModuleEnable();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public final boolean removeModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter(module, "module");
        if (!this.modules.contains(module)) {
            String string = "FlyFrame#removeModule not registered such module!";
            boolean bl = false;
            System.out.println((Object)string);
            return false;
        }
        try {
            this.modules.remove(module);
            module.onModuleDisable();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Module requireModule(@NotNull String name) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        Iterable $this$filter$iv = this.modules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Module it = (Module)element$iv$iv;
            boolean bl = false;
            if (!(it.getModuleName() == name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matched = (List)destination$iv$iv;
        if (matched.isEmpty()) {
            return null;
        }
        if (matched.size() > 1) {
            String string = "[FlyFrame][WARN] Duplicated Module Name found!";
            boolean bl = false;
            System.out.println((Object)string);
            string = "[FlyFrame][WARN] Duplicated Module Name:" + name;
            bl = false;
            System.out.println((Object)string);
        }
        ((Module)matched.get(0)).onEvent(ModuleEvent.MODULE_REQUIRED);
        return (Module)matched.get(0);
    }

    public final boolean isModuleExits(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.requireModule(name) != null;
    }

    public FlyFrame() {
        boolean bl = false;
        this.modules = new ArrayList();
    }
}

