package com.github.braisdom.objsql.spring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Deployer {

    private static final String[] SPRING_BOOT_VERSIONS = {"2.4.0", "2.3.6.RELEASE", "2.3.5.RELEASE", "2.3.4.RELEASE", "2.3.3.RELEASE", "2.3.2.RELEASE", "2.3.1.RELEASE", "2.3.0.RELEASE",
            "2.2.9.RELEASE", "2.2.8.RELEASE", "2.2.7.RELEASE", "2.2.6.RELEASE", "2.2.5.RELEASE",
            "2.2.4.RELEASE", "2.2.3.RELEASE", "2.2.2.RELEASE", "2.2.11.RELEASE", "2.2.10.RELEASE",
            "2.2.1.RELEASE", "2.2.0.RELEASE", "2.1.9.RELEASE", "2.1.8.RELEASE", "2.1.7.RELEASE",
            "2.1.6.RELEASE", "2.1.5.RELEASE", "2.1.4.RELEASE", "2.1.3.RELEASE", "2.1.2.RELEASE",
            "2.1.18.RELEASE", "2.1.17.RELEASE", "2.1.16.RELEASE", "2.1.15.RELEASE", "2.1.14.RELEASE",
            "2.1.13.RELEASE", "2.1.12.RELEASE", "2.1.11.RELEASE", "2.1.10.RELEASE", "2.1.1.RELEASE",
            "2.1.0.RELEASE", "2.0.9.RELEASE", "2.0.8.RELEASE", "2.0.7.RELEASE", "2.0.6.RELEASE",
            "2.0.5.RELEASE", "2.0.4.RELEASE", "2.0.3.RELEASE", "2.0.2.RELEASE", "2.0.1.RELEASE", "2.0.0.RELEASE"};

    private static final String MAVEN = "/Users/braisdom/apache-maven-3.6.3/bin/mvn";

    public static void main(String[] args) {
        ExecutorService executorService = Executors.newFixedThreadPool(1);

        for (int i = 0; i < SPRING_BOOT_VERSIONS.length; i++) {
            Runtime runtime = Runtime.getRuntime();
            int versionIndex = i;
            try {
                String options = " -Dgpg.passphrase=wyh1984 " +
                        " -Dspringboot-version=%s clean deploy -B -f /Users/braisdom/funcsql/springboot ";
                String command = String.format(options, SPRING_BOOT_VERSIONS[versionIndex]);
                Process process = runtime.exec(MAVEN + " " + command);
                System.out.println(SPRING_BOOT_VERSIONS[versionIndex] + " started");
                BufferedReader stdoutReader = new BufferedReader(
                        new InputStreamReader(process.getInputStream()));
                String line;
                while ((line = stdoutReader.readLine()) != null) {
                    System.out.println(line);
                    if (line.indexOf("BUILD FAILURE") != -1) {
                        System.out.println(SPRING_BOOT_VERSIONS[versionIndex] + " " + line);
                        break;
                    }
                    if (line.indexOf("BUILD SUCCESS") != -1) {
                        System.out.println(SPRING_BOOT_VERSIONS[versionIndex] + " " + line);
                        break;
                    }
                }
                int exitVal = process.waitFor();
                System.out.println("process exit value is " + exitVal);
            } catch (IOException e) {
                e.printStackTrace();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}
