/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.plugin;

import com.github.blutorange.maven.plugin.closurecompiler.common.ClosureCompileFileMessage;
import com.github.blutorange.maven.plugin.closurecompiler.common.ClosureConfig;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileException;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileHelper;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileMessage;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileProcessConfig;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileSpecifier;
import com.github.blutorange.maven.plugin.closurecompiler.common.OutputInterpolator;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.MojoMetadata;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.ProcessFilesTask;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import eu.maxschuster.dataurl.DataUrl;
import eu.maxschuster.dataurl.DataUrlBuilder;
import eu.maxschuster.dataurl.DataUrlEncoding;
import eu.maxschuster.dataurl.DataUrlSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;

public class ProcessJSFilesTask
extends ProcessFilesTask {
    public ProcessJSFilesTask(MojoMetadata mojoMeta, FileProcessConfig processConfig, FileSpecifier fileSpecifier, ClosureConfig closureConfig) throws IOException {
        super(mojoMeta, processConfig, fileSpecifier, closureConfig);
    }

    @Override
    protected void minify(File mergedFile, File minifiedFile) throws IOException, MojoFailureException {
        ArrayList<File> srcFiles = new ArrayList<File>();
        srcFiles.add(mergedFile);
        this.minify(srcFiles, minifiedFile);
    }

    @Override
    protected void minify(List<File> srcFiles, File minifiedFile) throws IOException, MojoFailureException {
        File sourceMapFile = this.closureConfig.getSourceMapInterpolator().apply(minifiedFile, minifiedFile.getParentFile());
        if (!this.haveFilesChanged(srcFiles, this.closureConfig.isCreateSourceMapFile() ? Arrays.asList(minifiedFile, sourceMapFile) : Collections.singleton(minifiedFile))) {
            return;
        }
        this.mkDir(this.targetDir);
        this.mkDir(minifiedFile.getParentFile());
        if (this.closureConfig.isCreateSourceMapFile()) {
            this.mkDir(sourceMapFile.getParentFile());
        }
        OutputInterpolator outputInterpolator = this.closureConfig.getOutputInterpolator();
        this.mojoMeta.getLog().info((CharSequence)("Creating the minified file [" + minifiedFile.getName() + "]."));
        this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + minifiedFile.getPath() + "]."));
        File baseDirForSourceFiles = this.getBaseDirForSourceFiles(minifiedFile, sourceMapFile);
        ArrayList<SourceFile> sourceFileList = new ArrayList<SourceFile>();
        for (File srcFile : srcFiles) {
            FileInputStream in = new FileInputStream(srcFile);
            Throwable throwable = null;
            try {
                SourceFile input = SourceFile.fromInputStream((String)FileHelper.relativizePath(baseDirForSourceFiles, srcFile), (InputStream)in, (Charset)this.mojoMeta.getEncoding());
                sourceFileList.add(input);
            }
            catch (Throwable input) {
                throwable = input;
                throw input;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable input) {
                        throwable.addSuppressed(input);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
        CompilerOptions options = this.closureConfig.getCompilerOptions(minifiedFile, sourceMapFile, baseDirForSourceFiles, this.sourceDir);
        this.mojoMeta.getLog().debug((CharSequence)("Transpiling from [" + options.getLanguageIn() + "] to [" + this.closureConfig.getLanguageOut() + "], strict=" + options.shouldEmitUseStrict()));
        ArrayList<SourceFile> externs = new ArrayList<SourceFile>();
        externs.addAll(CommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)this.closureConfig.getEnvironment()));
        externs.addAll(this.closureConfig.getExterns());
        Compiler compiler = new Compiler();
        compiler.compile(externs, sourceFileList, options);
        this.checkForErrors(compiler, baseDirForSourceFiles);
        String compiled = compiler.toSource();
        try (OutputStream out = this.mojoMeta.getBuildContext().newFileOutputStream(minifiedFile);
             OutputStreamWriter writer = new OutputStreamWriter(out, this.mojoMeta.getEncoding());){
            ((Writer)writer).append(outputInterpolator.apply(compiled));
            if (this.closureConfig.isCreateSourceMap()) {
                compiler.getSourceMap().setWrapperPrefix(outputInterpolator.getWrapperPrefix());
                this.createSourceMap(writer, compiler, minifiedFile, sourceMapFile);
            }
            ((Writer)writer).append(this.processConfig.getLineSeparator());
        }
        this.logCompressionGains(srcFiles, compiled);
    }

    private File getBaseDirForSourceFiles(File minifiedFile, File sourceMapFile) throws IOException {
        return (this.closureConfig.isCreateSourceMapFile() ? sourceMapFile : minifiedFile).getParentFile();
    }

    private void checkForErrors(Compiler compiler, File baseDirForSourceFiles) {
        Arrays.stream(compiler.getWarnings()).forEach(warning -> ClosureCompileFileMessage.ofWarning(warning, compiler, baseDirForSourceFiles).addTo(this.mojoMeta.getBuildContext()));
        JSError[] errors = compiler.getErrors();
        if (errors.length > 0) {
            Iterable<FileMessage> fileErrors = Arrays.stream(errors).map(error -> ClosureCompileFileMessage.ofError(error, compiler, baseDirForSourceFiles))::iterator;
            throw new FileException(fileErrors);
        }
    }

    private void createSourceMap(Writer writer, Compiler compiler, File minifiedFile, File sourceMapFile) throws IOException {
        switch (this.closureConfig.getSourceMapOutputType()) {
            case inline: {
                this.mojoMeta.getLog().info((CharSequence)"Creating the inline source map.");
                StringBuilder sb = new StringBuilder();
                compiler.getSourceMap().appendTo((Appendable)sb, minifiedFile.getName());
                DataUrl unserialized = new DataUrlBuilder().setMimeType("application/json").setEncoding(DataUrlEncoding.BASE64).setData(sb.toString().getBytes(StandardCharsets.UTF_8)).setHeader("charset", "utf-8").build();
                DataUrlSerializer serializer = new DataUrlSerializer();
                String dataUrl = serializer.serialize(unserialized);
                writer.append(this.processConfig.getLineSeparator());
                writer.append("//# sourceMappingURL=" + dataUrl);
                break;
            }
            case file: {
                this.flushSourceMap(sourceMapFile, minifiedFile.getName(), compiler.getSourceMap());
                break;
            }
            case reference: {
                this.flushSourceMap(sourceMapFile, minifiedFile.getName(), compiler.getSourceMap());
                writer.append(this.processConfig.getLineSeparator());
                writer.append("//# sourceMappingURL=" + sourceMapFile.getName());
                break;
            }
            default: {
                this.mojoMeta.getLog().warn((CharSequence)("Unknown source map inclusion type [" + (Object)((Object)this.closureConfig.getSourceMapOutputType()) + "]"));
                throw new RuntimeException("unknown source map inclusion type: " + (Object)((Object)this.closureConfig.getSourceMapOutputType()));
            }
        }
    }

    private void flushSourceMap(File sourceMapFile, String minifyFileName, SourceMap sourceMap) throws IOException {
        this.mojoMeta.getLog().info((CharSequence)("Creating the minified files map [" + sourceMapFile.getName() + "]."));
        this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + sourceMapFile.getPath() + "]."));
        try (OutputStream out = this.mojoMeta.getBuildContext().newFileOutputStream(sourceMapFile);
             OutputStreamWriter writer = new OutputStreamWriter(out, this.mojoMeta.getEncoding());){
            sourceMap.appendTo((Appendable)writer, minifyFileName);
        }
        catch (IOException e) {
            this.mojoMeta.getLog().error((CharSequence)("Failed to write the JavaScript Source Map file [" + sourceMapFile.getName() + "]."), (Throwable)e);
            this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + sourceMapFile.getPath() + "]"));
        }
    }
}

