/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileHelper {
    private FileHelper() {
    }

    public static String relativizePath(File base, File target) throws IOException {
        base = base.isDirectory() ? base : base.getParentFile();
        Path basePath = base.getCanonicalFile().toPath();
        Path targetPath = Paths.get(target.getCanonicalPath(), new String[0]);
        String relativePath = basePath.relativize(targetPath).toString();
        return relativePath;
    }

    public static File getAbsoluteFile(File basedir, File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(basedir, file.getPath());
    }

    public static File getAbsoluteFile(File basedir, String file) {
        return FileHelper.getAbsoluteFile(basedir, new File(file));
    }
}

