/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import com.github.blutorange.maven.plugin.closurecompiler.common.FileHelper;
import com.github.blutorange.maven.plugin.closurecompiler.common.FilenameInterpolator;
import com.github.blutorange.maven.plugin.closurecompiler.common.OutputInterpolator;
import com.github.blutorange.maven.plugin.closurecompiler.common.SourceMapOutputType;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.MinifyMojo;
import com.google.common.base.Strings;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.plugin.MojoFailureException;

public class ClosureConfig {
    private static final String BINARY_PREFIX = "0b";
    private static final String FILE_PREFIX = "file:";
    private final CompilationLevel compilationLevel;
    private final CompilerOptions compilerOptions;
    private final CompilerOptions.DependencyMode dependencyMode;
    private final Collection<String> entryPoints;
    private final CompilerOptions.Environment environment;
    private final List<SourceFile> externs;
    private final boolean includeSourcesContent;
    private final CompilerOptions.LanguageMode languageOut;
    private final OutputInterpolator outputInterpolator;
    private final SourceMap.Format sourceMapFormat;
    private final FilenameInterpolator sourceMapInterpolator;
    private final SourceMapOutputType sourceMapOutputType;

    private static CompilerOptions createCompilerOptions(MinifyMojo mojo) throws MojoFailureException {
        CompilerOptions options = new CompilerOptions();
        options.setAngularPass(mojo.isClosureAngularPass());
        options.setClosurePass(mojo.isClosureProcessCommonJsModules() ? true : mojo.isClosureProcessClosurePrimitives());
        options.setColorizeErrorOutput(mojo.isClosureColorizeErrorOutput());
        options.setDartPass(mojo.isClosureDartPass());
        options.setDefineReplacements(ClosureConfig.createDefineReplacements(mojo));
        options.setEmitUseStrict(mojo.isClosureEmitUseStrict());
        options.setEnvironment(mojo.getClosureEnvironment());
        options.setExtraAnnotationNames(mojo.getClosureExtraAnnotations());
        if (!mojo.getClosureForceInjectLibs().isEmpty()) {
            options.setForceLibraryInjection(mojo.getClosureForceInjectLibs());
        }
        options.setLanguageIn(mojo.getClosureLanguageIn());
        options.setLanguageOut(mojo.getClosureLanguageOut());
        options.setModuleResolutionMode(mojo.getClosureModuleResolution());
        options.setOutputCharset(Charset.forName(mojo.getEncoding()));
        options.setPreferLineBreakAtEndOfFile(true);
        options.setPreferSingleQuotes(mojo.isClosurePreferSingleQuotes());
        options.setPrettyPrint(mojo.isClosurePrettyPrint());
        options.setPreventLibraryInjection(!mojo.isClosureInjectLibraries());
        options.setProcessCommonJSModules(mojo.isClosureProcessCommonJsModules());
        if (StringUtils.isNotEmpty((CharSequence)mojo.getClosureRenameVariablePrefix())) {
            options.setRenamePrefix(mojo.getClosureRenameVariablePrefix());
        }
        if (StringUtils.isNotEmpty((CharSequence)mojo.getClosureRenamePrefixNamespace())) {
            options.setRenamePrefixNamespace(mojo.getClosureRenamePrefixNamespace());
        }
        options.setRewritePolyfills(mojo.isClosureRewritePolyfills());
        options.setStrictModeInput(mojo.isClosureStrictModeInput());
        options.setTrustedStrings(mojo.isClosureTrustedStrings());
        mojo.getClosureCompilationLevel().setOptionsForCompilationLevel(options);
        if (mojo.isClosureAssumeFunctionWrapper()) {
            mojo.getClosureCompilationLevel().setWrappedOutputOptimizations(options);
        }
        if (mojo.isClosureDebug()) {
            mojo.getClosureCompilationLevel().setDebugOptionsForCompilationLevel(options);
        }
        if (mojo.isClosureUseTypesForOptimization()) {
            mojo.getClosureCompilationLevel().setTypeBasedOptimizationOptions(options);
        }
        mojo.getClosureWarningLevel().setOptionsForWarningLevel(options);
        ClosureConfig.createWarningLevels(mojo).forEach((arg_0, arg_1) -> ((CompilerOptions)options).setWarningLevel(arg_0, arg_1));
        return options;
    }

    private static Map<String, Object> createDefineReplacements(MinifyMojo mojo) {
        HashMap<String, Object> defineReplacements = new HashMap<String, Object>();
        for (Map.Entry<String, String> defineReplacement : mojo.getClosureDefineReplacements().entrySet()) {
            String key = defineReplacement.getKey();
            String value = Strings.nullToEmpty((String)defineReplacement.getValue()).trim();
            if (Strings.isNullOrEmpty((String)value)) {
                throw new RuntimeException("Define replacement " + key + " does not have a value.");
            }
            if ("true".equals(value)) {
                defineReplacements.put(key, Boolean.TRUE);
                continue;
            }
            if ("false".equals(value)) {
                defineReplacements.put(key, Boolean.FALSE);
                continue;
            }
            if (value.startsWith("\"") || value.startsWith("'")) {
                defineReplacements.put(key, StringEscapeUtils.unescapeEcmaScript((String)value.substring(1, value.length() - 1)));
                continue;
            }
            if (value.startsWith(BINARY_PREFIX)) {
                try {
                    defineReplacements.put(key, Integer.valueOf(value.substring(BINARY_PREFIX.length()), 2));
                    continue;
                }
                catch (NumberFormatException e) {
                    mojo.getLog().warn((CharSequence)("Cannot parse a (binary) number: " + value), (Throwable)e);
                }
            }
            if (value.startsWith("0") && value.charAt(1) != '.') {
                try {
                    defineReplacements.put(key, Integer.valueOf(value.substring(1), 8));
                    continue;
                }
                catch (NumberFormatException e) {
                    mojo.getLog().warn((CharSequence)("Cannot parse an (octal) number: " + value), (Throwable)e);
                }
            }
            try {
                defineReplacements.put(key, Integer.valueOf(value, 10));
            }
            catch (NumberFormatException e) {
                try {
                    defineReplacements.put(key, Double.valueOf(value));
                }
                catch (NumberFormatException e2) {
                    mojo.getLog().warn((CharSequence)("Cannot parse as a number: " + value), (Throwable)e2);
                    mojo.getLog().warn((CharSequence)("Cannot parse define replacement value: '" + value + "'. Use quotation marks for a string."));
                    defineReplacements.put(key, value);
                }
            }
        }
        return defineReplacements;
    }

    private static List<SourceFile> createExterns(MinifyMojo mojo) {
        ArrayList<SourceFile> externs = new ArrayList<SourceFile>();
        for (String extern : mojo.getClosureExterns()) {
            externs.add(SourceFile.fromFile((String)new File(mojo.getBaseSourceDir(), extern).getAbsolutePath(), (Charset)Charset.forName(mojo.getEncoding())));
        }
        return externs;
    }

    private static OutputInterpolator createOutputInterpolator(MinifyMojo mojo) {
        String outputWrapper = mojo.getClosureOutputWrapper();
        if (StringUtils.isBlank((CharSequence)outputWrapper)) {
            return OutputInterpolator.forIdentity();
        }
        return OutputInterpolator.forPattern(outputWrapper);
    }

    private static Map<DiagnosticGroup, CheckLevel> createWarningLevels(MinifyMojo mojo) throws MojoFailureException {
        HashMap<DiagnosticGroup, CheckLevel> warningLevels = new HashMap<DiagnosticGroup, CheckLevel>();
        DiagnosticGroups diagnosticGroups = new DiagnosticGroups();
        for (Map.Entry<String, String> warningLevel : mojo.getClosureWarningLevels().entrySet()) {
            DiagnosticGroup diagnosticGroup = diagnosticGroups.forName(warningLevel.getKey());
            if (diagnosticGroup == null) {
                throw new MojoFailureException("Failed to process closureWarningLevels: " + warningLevel.getKey() + " is an invalid DiagnosticGroup");
            }
            try {
                CheckLevel checkLevel = CheckLevel.valueOf((String)warningLevel.getValue());
                warningLevels.put(diagnosticGroup, checkLevel);
            }
            catch (IllegalArgumentException e) {
                throw new MojoFailureException("Failed to process closureWarningLevels: " + warningLevel.getKey() + " is an invalid CheckLevel");
            }
        }
        return warningLevels;
    }

    public ClosureConfig(MinifyMojo mojo) throws MojoFailureException {
        this.compilationLevel = mojo.getClosureCompilationLevel();
        this.dependencyMode = mojo.getClosureDependencyMode();
        this.entryPoints = new ArrayList<String>(mojo.getClosureDependencyEntryPoints());
        this.environment = mojo.getClosureEnvironment();
        this.includeSourcesContent = mojo.isClosureIncludeSourcesContent();
        this.languageOut = mojo.getClosureLanguageOut();
        this.sourceMapFormat = mojo.isClosureCreateSourceMap() ? SourceMap.Format.V3 : null;
        this.sourceMapOutputType = mojo.getClosureSourceMapOutputType();
        this.sourceMapInterpolator = new FilenameInterpolator(mojo.getClosureSourceMapName());
        this.compilerOptions = ClosureConfig.createCompilerOptions(mojo);
        this.externs = ClosureConfig.createExterns(mojo);
        this.outputInterpolator = ClosureConfig.createOutputInterpolator(mojo);
    }

    private DependencyOptions createDependencyOptions(File baseDirForSourceFiles, File sourceDir) throws MojoFailureException, IOException {
        DependencyOptions dependencyOptions = new DependencyOptions();
        ArrayList<ModuleIdentifier> entryPointsMapped = new ArrayList<ModuleIdentifier>();
        for (String entryPoint : CollectionUtils.emptyIfNull(this.entryPoints)) {
            if (entryPoint.startsWith(FILE_PREFIX)) {
                File file = new File(sourceDir, entryPoint.substring(FILE_PREFIX.length())).getCanonicalFile();
                entryPointsMapped.add(ModuleIdentifier.forFile((String)FileHelper.relativizePath(baseDirForSourceFiles, file)));
                continue;
            }
            entryPointsMapped.add(ModuleIdentifier.forClosure((String)entryPoint));
        }
        if (this.dependencyMode == CompilerOptions.DependencyMode.STRICT) {
            if (this.entryPoints.isEmpty()) {
                throw new MojoFailureException("When dependency_mode=STRICT, you must specify at least one entry_point");
            }
            dependencyOptions.setDependencyPruning(true).setDependencySorting(true).setMoocherDropping(true);
        } else if (this.dependencyMode == CompilerOptions.DependencyMode.LOOSE || !this.entryPoints.isEmpty()) {
            dependencyOptions.setDependencyPruning(true).setDependencySorting(true).setMoocherDropping(false);
        }
        dependencyOptions.setEntryPoints(entryPointsMapped);
        return dependencyOptions;
    }

    public CompilationLevel getCompilationLevel() {
        return this.compilationLevel;
    }

    public CompilerOptions getCompilerOptions(File minifiedFile, File sourceMapFile, File baseDirForSourceFiles, File sourceDir) throws MojoFailureException, IOException {
        CompilerOptions compilerOptions = (CompilerOptions)SerializationUtils.clone((Serializable)this.compilerOptions);
        compilerOptions.setDependencyOptions(this.createDependencyOptions(baseDirForSourceFiles, sourceDir));
        if (this.sourceMapFormat != null) {
            compilerOptions.setSourceMapFormat(this.sourceMapFormat);
            compilerOptions.setSourceMapIncludeSourcesContent(this.includeSourcesContent);
            compilerOptions.setSourceMapOutputPath(sourceMapFile.getPath());
        }
        return compilerOptions;
    }

    public CompilerOptions.Environment getEnvironment() {
        return this.environment;
    }

    public List<SourceFile> getExterns() {
        return this.externs;
    }

    public CompilerOptions.LanguageMode getLanguageOut() {
        return this.languageOut;
    }

    public OutputInterpolator getOutputInterpolator() {
        return this.outputInterpolator;
    }

    public FilenameInterpolator getSourceMapInterpolator() {
        return this.sourceMapInterpolator;
    }

    public SourceMapOutputType getSourceMapOutputType() {
        return this.sourceMapOutputType;
    }

    public boolean isCreateSourceMap() {
        return this.sourceMapFormat != null;
    }

    public boolean isCreateSourceMapFile() {
        return this.isCreateSourceMap() && this.sourceMapOutputType.isCreateFile();
    }
}

