package com.gateway.connector.utils;

import java.util.StringTokenizer;

/**
 * topic匹配规则
 * 
 *
 */
public class TopicUtils {
	static final String WILDCARD = "*";
	static final String ALL_WILDCARD = "**";

	public static boolean isWildcard(String topic) {
		return topic.indexOf("*") > -1;
	}

	public static boolean matchTopic(String szWildDest, String szDest) {
		boolean bMatched = false;

		if (szWildDest.equals(szDest)) {
			return true;
		}
		if (!isWildcard(szWildDest))
		{
			return false;
		}
		if(szWildDest.equals(ALL_WILDCARD)) {
			return true;
		}
		StringTokenizer wildPart = new StringTokenizer(szWildDest, ".");
		StringTokenizer destPart = new StringTokenizer(szDest, ".");

		int tokenCountDiff = destPart.countTokens() - wildPart.countTokens();

		if ((tokenCountDiff != 0) && (tokenCountDiff != -1)) {
			if (szWildDest.indexOf("**") < 0) {

			} else {
				while ((wildPart.hasMoreElements()) && (destPart.hasMoreElements())) {
					String szWildDescPart = (String) wildPart.nextElement();
					String szDescPart = (String) destPart.nextElement();

					if (szWildDescPart.equals("*")) {
						bMatched = true;
					} else {
						if (szWildDescPart.equals("**")) {
							bMatched = true;
							break;
						}
						if (szWildDescPart.equals(szDescPart)) {
							bMatched = true;
						} else {
							bMatched = false;
							break;
						}
					}

				}
			}
		} else
			while ((wildPart.hasMoreElements()) && (destPart.hasMoreElements())) {
				String szWildDescPart = (String) wildPart.nextElement();
				String szDescPart = (String) destPart.nextElement();

				if (szWildDescPart.equals("*")) {
					bMatched = true;
				} else {
					if (szWildDescPart.equals("**")) {
						bMatched = true;
						break;
					}
					if (szWildDescPart.equals(szDescPart)) {
						bMatched = true;
					} else {
						bMatched = false;
						break;
					}
				}
			}

		wildPart = null;
		destPart = null;

		return bMatched;
	}
}
