package com.gateway.connector.utils;

import java.util.concurrent.atomic.AtomicInteger;

public class SeqUtils {
	private static AtomicInteger seq = new AtomicInteger(0);

	public static int getCurrentSeq() {
		return seq.get();
	}

	public static int getSeq() {
		int s = seq.addAndGet(1);
		if (s == Integer.MAX_VALUE) {
			clear();
		}
		return s;
	}

	public static void set(int value) {
		seq.set(value);
	}

	public static void clear() {
		set(0);
	}
}
