package com.gateway.connector.utils;


import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLClient extends DefaultHttpClient {
	private static Logger logger = LoggerFactory.getLogger(SSLClient.class);

	public SSLClient() throws Exception {
		super();
		SSLContext ctx = SSLContext.getInstance("SSL");
		X509TrustManager tm = new X509TrustManager() {
			@Override
			public void checkClientTrusted(X509Certificate[] chain,
					String authType) throws CertificateException {
			}

			@Override
			public void checkServerTrusted(X509Certificate[] chain,
					String authType) throws CertificateException {
			}

			@Override
			public X509Certificate[] getAcceptedIssuers() {
				return null;
			}
		};
		ctx.init(null, new TrustManager[] { tm }, null);
		SSLSocketFactory ssf = new SSLSocketFactory(ctx);
		ssf.setHostnameVerifier(new AllowAllHostnameVerifier());
		ClientConnectionManager ccm = this.getConnectionManager();
		SchemeRegistry sr = ccm.getSchemeRegistry();
		sr.register(new Scheme("https", 443, ssf));
	}

	public static String doPost(String url, NameValuePair[] datas)
			throws Exception {
		SSLClient httpclient = new SSLClient();
		HttpPost httpget = new HttpPost(url);

		// StringEntity entity = new StringEntity(paras, "UTF-8");
		List<NameValuePair> lt = new ArrayList<NameValuePair>();
		for (NameValuePair nameValuePair : datas) {
			lt.add(nameValuePair);
		}
		httpget.setEntity(new UrlEncodedFormEntity(lt, "UTF-8"));

		ResponseHandler<String> responseHandler = new BasicResponseHandler();
		String txtJson = httpclient.execute(httpget, responseHandler);
		httpget.releaseConnection();
		httpclient.getConnectionManager().shutdown();
		return txtJson;
	}

	private static final String APPLICATION_JSON = "application/json";
	private static final String CONTENT_TYPE_TEXT_JSON = "text/json";

	public static String doPost(String url, String json, String... sid)
			throws Exception {
		SSLClient httpclient = new SSLClient();
		HttpPost httpget = new HttpPost(url);

		if (!StringUtils.isEmpty(json)) {
			httpget.addHeader(HTTP.CONTENT_TYPE, APPLICATION_JSON);
			StringEntity se = new StringEntity(json, Charset.forName("UTF-8"));
			se.setContentType(CONTENT_TYPE_TEXT_JSON);
			se.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE,
					APPLICATION_JSON));
			httpget.setEntity(se);
		}
		if (sid != null && sid.length > 0) {
			httpget.addHeader(new BasicHeader("Cookie", "JSESSIONID=" + sid[0]));
		}
		HttpResponse response = httpclient.execute(httpget);
		HttpEntity entity = response.getEntity();
		String txtJson = EntityUtils.toString(entity, "UTF-8").trim();
		httpget.releaseConnection();
		httpclient.getConnectionManager().shutdown();
		return txtJson;
	}

	public static String doGet(String url, String json, String... sid)
			throws Exception {
		SSLClient httpclient = new SSLClient();
		logger.info("doGet:url={},content={}", url, json);
		HttpGet httpget = new HttpGet(url);

		httpget.addHeader(HTTP.CONTENT_TYPE, APPLICATION_JSON);
		StringEntity se = new StringEntity(json);
		se.setContentType(CONTENT_TYPE_TEXT_JSON);
		se.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE,
				APPLICATION_JSON));

		if (sid != null && sid.length > 0) {
			httpget.addHeader(new BasicHeader("Cookie", "JSESSIONID=" + sid[0]));
		}

		HttpResponse response = httpclient.execute(httpget);
		HttpEntity entity = response.getEntity();
		String txtJson = EntityUtils.toString(entity, "UTF-8").trim();
		httpget.releaseConnection();
		httpclient.getConnectionManager().shutdown();
		String printMsg=txtJson;
		if(txtJson.length()>=2000)
		{
			printMsg=txtJson.substring(0, 2000)+"... too long";
		}
		logger.info("doGet:respStr={}", printMsg);
		return txtJson;
	}
}
