package com.gateway.connector.utils;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.gateway.connector.proto.Cmd;
import com.gateway.connector.proto.Format;
import com.gateway.connector.proto.Proto;
import com.gateway.connector.tcp.client.ProtoReq;

/**
 * 协议工具类
 * 
 * @author deshuai.kong
 *
 */
public class ProtoUtils {

	@SuppressWarnings("rawtypes")
	public static ProtoReq generateConnect(String sid, String userName, String pwd,
			Map extendParam) {
		ProtoReq req = new ProtoReq();
		Proto proto = new Proto();
		proto.setCmd(Cmd.CONNECT);
		proto.setFormat(Format.REQUEST);
		proto.setSeq(SeqUtils.getSeq());
		proto.setSessionId(sid);
		HashMap<String, Object> hm = new HashMap<String, Object>();
		hm.put("userName", userName);
		hm.put("pwd", pwd);
		if (extendParam != null) {
			hm.put("extendParam", extendParam);
		}
		byte[] body = JSON.toJSONBytes(hm);
		proto.setBody(body);
		req.setReqProto(proto);
		return req;
	}

	public static Proto generateHeartbeat(String sid) {
		Proto proto = new Proto();
		proto.setCmd(Cmd.HEARTBEAT);
		proto.setFormat(Format.SEND);
		proto.setSeq(SeqUtils.getSeq());
		proto.setSessionId(sid);
		return proto;
	}

	public static ProtoReq generateRequest(String sid, String serverName, String method, String content) {
		ProtoReq req = new ProtoReq();
		Proto proto = new Proto();
		proto.setCmd(Cmd.SEND);
		proto.setFormat(Format.REQUEST);
		proto.setSeq(SeqUtils.getSeq());
		proto.setSessionId(sid);
		HashMap<String, String> hm = new HashMap<String, String>();
		hm.put("serverName", serverName);
		hm.put("method", method);
		hm.put("content", content);
		byte[] body = JSON.toJSONBytes(hm);
		proto.setBody(body);
		req.setReqProto(proto);
		return req;
	}

	public static Proto generateReplySuccess(String sid, int cmd, int seq) {

		return generateReply(sid, cmd, seq, "0000", "Success");
	}

	public static Proto generateReply(String sid, int cmd, int seq, String code, String msg) {
		Proto proto = new Proto();
		proto.setCmd(cmd);
		proto.setFormat(Format.REPLY);
		proto.setSeq(seq);
		proto.setSessionId(sid);
		if (StringUtils.isNoneEmpty(code)) {
			HashMap<String, String> hm = new HashMap<>();
			hm.put("Code", code);
			hm.put("Msg", msg);
			proto.setBody(JSON.toJSONBytes(hm));
		}

		return proto;
	}

	public static Proto generateNotify(String sid, String topic, String content) {

		Proto proto = new Proto();
		proto.setCmd(Cmd.SEND);
		proto.setFormat(Format.NOTIFY);
		proto.setSeq(SeqUtils.getSeq());
		proto.setSessionId(sid);
		HashMap<String, String> hm = new HashMap<String, String>();
		hm.put("topic", topic);
		hm.put("content", content);
		byte[] body = JSON.toJSONBytes(hm);
		proto.setBody(body);

		return proto;
	}

	public static HashMap<String, String> getNotify(byte[] body) {
		HashMap<String, String> hm = JSON.parseObject(body, HashMap.class);

		return hm;
	}

	public static Proto generateNotify(String sid, byte[] body) {
		Proto proto = new Proto();
		proto.setCmd(Cmd.SEND);
		proto.setFormat(Format.NOTIFY);
		proto.setSeq(SeqUtils.getCurrentSeq());
		proto.setSessionId(sid);
		proto.setBody(body);

		return proto;
	}

	public static byte[] gzipBody(boolean isGzip, byte[] body) {
		if (isGzip) {
			return GzipUtils.gzip(body);
		} else {
			return body;
		}
	}

	public static byte[] ungzipBody(boolean isGzip, byte[] body) {
		if (isGzip) {
			return GzipUtils.ungzip(body);
		} else {
			return body;
		}
	}

}
